/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.AlertLifecycleState;
import com.oracle.bmc.datasafe.model.AlertSeverity;
import com.oracle.bmc.datasafe.model.AlertStatus;
import com.oracle.bmc.datasafe.model.AlertType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Alert
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="status")
    private final AlertStatus status;
    @JsonProperty(value="severity")
    private final AlertSeverity severity;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="operationTime")
    private final Date operationTime;
    @JsonProperty(value="operation")
    private final String operation;
    @JsonProperty(value="operationStatus")
    private final OperationStatus operationStatus;
    @JsonProperty(value="targetIds")
    private final List<String> targetIds;
    @JsonProperty(value="targetNames")
    private final List<String> targetNames;
    @JsonProperty(value="policyId")
    private final String policyId;
    @JsonProperty(value="alertType")
    private final AlertType alertType;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="featureDetails")
    private final Map<String, Map<String, Object>> featureDetails;
    @JsonProperty(value="comment")
    private final String comment;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final AlertLifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "status", "severity", "displayName", "description", "operationTime", "operation", "operationStatus", "targetIds", "targetNames", "policyId", "alertType", "resourceName", "featureDetails", "comment", "compartmentId", "lifecycleState", "timeCreated", "timeUpdated", "freeformTags", "definedTags", "systemTags"})
    public Alert(String id, AlertStatus status, AlertSeverity severity, String displayName, String description, Date operationTime, String operation, OperationStatus operationStatus, List<String> targetIds, List<String> targetNames, String policyId, AlertType alertType, String resourceName, Map<String, Map<String, Object>> featureDetails, String comment, String compartmentId, AlertLifecycleState lifecycleState, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.status = status;
        this.severity = severity;
        this.displayName = displayName;
        this.description = description;
        this.operationTime = operationTime;
        this.operation = operation;
        this.operationStatus = operationStatus;
        this.targetIds = targetIds;
        this.targetNames = targetNames;
        this.policyId = policyId;
        this.alertType = alertType;
        this.resourceName = resourceName;
        this.featureDetails = featureDetails;
        this.comment = comment;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public AlertStatus getStatus() {
        return this.status;
    }

    public AlertSeverity getSeverity() {
        return this.severity;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getOperationTime() {
        return this.operationTime;
    }

    public String getOperation() {
        return this.operation;
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public List<String> getTargetIds() {
        return this.targetIds;
    }

    public List<String> getTargetNames() {
        return this.targetNames;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public AlertType getAlertType() {
        return this.alertType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Map<String, Map<String, Object>> getFeatureDetails() {
        return this.featureDetails;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public AlertLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Alert(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", operationTime=").append(String.valueOf(this.operationTime));
        sb.append(", operation=").append(String.valueOf(this.operation));
        sb.append(", operationStatus=").append(String.valueOf((Object)this.operationStatus));
        sb.append(", targetIds=").append(String.valueOf(this.targetIds));
        sb.append(", targetNames=").append(String.valueOf(this.targetNames));
        sb.append(", policyId=").append(String.valueOf(this.policyId));
        sb.append(", alertType=").append(String.valueOf((Object)this.alertType));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", featureDetails=").append(String.valueOf(this.featureDetails));
        sb.append(", comment=").append(String.valueOf(this.comment));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.operationTime, other.operationTime) && Objects.equals(this.operation, other.operation) && Objects.equals((Object)this.operationStatus, (Object)other.operationStatus) && Objects.equals(this.targetIds, other.targetIds) && Objects.equals(this.targetNames, other.targetNames) && Objects.equals(this.policyId, other.policyId) && Objects.equals((Object)this.alertType, (Object)other.alertType) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.featureDetails, other.featureDetails) && Objects.equals(this.comment, other.comment) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.operationTime == null ? 43 : this.operationTime.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + (this.operationStatus == null ? 43 : this.operationStatus.hashCode());
        result = result * 59 + (this.targetIds == null ? 43 : this.targetIds.hashCode());
        result = result * 59 + (this.targetNames == null ? 43 : this.targetNames.hashCode());
        result = result * 59 + (this.policyId == null ? 43 : this.policyId.hashCode());
        result = result * 59 + (this.alertType == null ? 43 : this.alertType.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.featureDetails == null ? 43 : this.featureDetails.hashCode());
        result = result * 59 + (this.comment == null ? 43 : this.comment.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperationStatus implements BmcEnum
    {
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationStatus> map;

        private OperationStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationStatus.class);
            map = new HashMap<String, OperationStatus>();
            for (OperationStatus v : OperationStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="status")
        private AlertStatus status;
        @JsonProperty(value="severity")
        private AlertSeverity severity;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="operationTime")
        private Date operationTime;
        @JsonProperty(value="operation")
        private String operation;
        @JsonProperty(value="operationStatus")
        private OperationStatus operationStatus;
        @JsonProperty(value="targetIds")
        private List<String> targetIds;
        @JsonProperty(value="targetNames")
        private List<String> targetNames;
        @JsonProperty(value="policyId")
        private String policyId;
        @JsonProperty(value="alertType")
        private AlertType alertType;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="featureDetails")
        private Map<String, Map<String, Object>> featureDetails;
        @JsonProperty(value="comment")
        private String comment;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private AlertLifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder status(AlertStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder severity(AlertSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder operationTime(Date operationTime) {
            this.operationTime = operationTime;
            this.__explicitlySet__.add("operationTime");
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus = operationStatus;
            this.__explicitlySet__.add("operationStatus");
            return this;
        }

        public Builder targetIds(List<String> targetIds) {
            this.targetIds = targetIds;
            this.__explicitlySet__.add("targetIds");
            return this;
        }

        public Builder targetNames(List<String> targetNames) {
            this.targetNames = targetNames;
            this.__explicitlySet__.add("targetNames");
            return this;
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            this.__explicitlySet__.add("policyId");
            return this;
        }

        public Builder alertType(AlertType alertType) {
            this.alertType = alertType;
            this.__explicitlySet__.add("alertType");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder featureDetails(Map<String, Map<String, Object>> featureDetails) {
            this.featureDetails = featureDetails;
            this.__explicitlySet__.add("featureDetails");
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            this.__explicitlySet__.add("comment");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(AlertLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Alert build() {
            Alert model = new Alert(this.id, this.status, this.severity, this.displayName, this.description, this.operationTime, this.operation, this.operationStatus, this.targetIds, this.targetNames, this.policyId, this.alertType, this.resourceName, this.featureDetails, this.comment, this.compartmentId, this.lifecycleState, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Alert model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("operationTime")) {
                this.operationTime(model.getOperationTime());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            if (model.wasPropertyExplicitlySet("operationStatus")) {
                this.operationStatus(model.getOperationStatus());
            }
            if (model.wasPropertyExplicitlySet("targetIds")) {
                this.targetIds(model.getTargetIds());
            }
            if (model.wasPropertyExplicitlySet("targetNames")) {
                this.targetNames(model.getTargetNames());
            }
            if (model.wasPropertyExplicitlySet("policyId")) {
                this.policyId(model.getPolicyId());
            }
            if (model.wasPropertyExplicitlySet("alertType")) {
                this.alertType(model.getAlertType());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("featureDetails")) {
                this.featureDetails(model.getFeatureDetails());
            }
            if (model.wasPropertyExplicitlySet("comment")) {
                this.comment(model.getComment());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

