/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datalabelingservice.model.UpdateDatasetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDatasetRequest
extends BmcRequest<UpdateDatasetDetails> {
    private String datasetId;
    private UpdateDatasetDetails updateDatasetDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getDatasetId() {
        return this.datasetId;
    }

    public UpdateDatasetDetails getUpdateDatasetDetails() {
        return this.updateDatasetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateDatasetDetails getBody$() {
        return this.updateDatasetDetails;
    }

    public Builder toBuilder() {
        return new Builder().datasetId(this.datasetId).updateDatasetDetails(this.updateDatasetDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",datasetId=").append(String.valueOf(this.datasetId));
        sb.append(",updateDatasetDetails=").append(String.valueOf((Object)this.updateDatasetDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.datasetId, other.datasetId) && Objects.equals((Object)this.updateDatasetDetails, (Object)other.updateDatasetDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.datasetId == null ? 43 : this.datasetId.hashCode());
        result = result * 59 + (this.updateDatasetDetails == null ? 43 : this.updateDatasetDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDatasetRequest, UpdateDatasetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String datasetId = null;
        private UpdateDatasetDetails updateDatasetDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public Builder updateDatasetDetails(UpdateDatasetDetails updateDatasetDetails) {
            this.updateDatasetDetails = updateDatasetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDatasetRequest o) {
            this.datasetId(o.getDatasetId());
            this.updateDatasetDetails(o.getUpdateDatasetDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDatasetRequest build() {
            UpdateDatasetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDatasetDetails body) {
            this.updateDatasetDetails(body);
            return this;
        }

        public UpdateDatasetRequest buildWithoutInvocationCallback() {
            UpdateDatasetRequest request = new UpdateDatasetRequest();
            request.datasetId = this.datasetId;
            request.updateDatasetDetails = this.updateDatasetDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

