/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datalabelingservice.model.TextFileTypeMetadata;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="formatType")
@JsonFilter(value="explicitlySetFilter")
public final class DelimitedFileTypeMetadata
extends TextFileTypeMetadata {
    @JsonProperty(value="columnName")
    private final String columnName;
    @JsonProperty(value="columnIndex")
    private final Integer columnIndex;
    @JsonProperty(value="columnDelimiter")
    private final String columnDelimiter;
    @JsonProperty(value="lineDelimiter")
    private final String lineDelimiter;
    @JsonProperty(value="escapeCharacter")
    private final String escapeCharacter;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DelimitedFileTypeMetadata(String columnName, Integer columnIndex, String columnDelimiter, String lineDelimiter, String escapeCharacter) {
        this.columnName = columnName;
        this.columnIndex = columnIndex;
        this.columnDelimiter = columnDelimiter;
        this.lineDelimiter = lineDelimiter;
        this.escapeCharacter = escapeCharacter;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DelimitedFileTypeMetadata(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", columnName=").append(String.valueOf(this.columnName));
        sb.append(", columnIndex=").append(String.valueOf(this.columnIndex));
        sb.append(", columnDelimiter=").append(String.valueOf(this.columnDelimiter));
        sb.append(", lineDelimiter=").append(String.valueOf(this.lineDelimiter));
        sb.append(", escapeCharacter=").append(String.valueOf(this.escapeCharacter));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DelimitedFileTypeMetadata)) {
            return false;
        }
        DelimitedFileTypeMetadata other = (DelimitedFileTypeMetadata)((Object)o);
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.columnIndex, other.columnIndex) && Objects.equals(this.columnDelimiter, other.columnDelimiter) && Objects.equals(this.lineDelimiter, other.lineDelimiter) && Objects.equals(this.escapeCharacter, other.escapeCharacter) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.columnIndex == null ? 43 : this.columnIndex.hashCode());
        result = result * 59 + (this.columnDelimiter == null ? 43 : this.columnDelimiter.hashCode());
        result = result * 59 + (this.lineDelimiter == null ? 43 : this.lineDelimiter.hashCode());
        result = result * 59 + (this.escapeCharacter == null ? 43 : this.escapeCharacter.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="columnName")
        private String columnName;
        @JsonProperty(value="columnIndex")
        private Integer columnIndex;
        @JsonProperty(value="columnDelimiter")
        private String columnDelimiter;
        @JsonProperty(value="lineDelimiter")
        private String lineDelimiter;
        @JsonProperty(value="escapeCharacter")
        private String escapeCharacter;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.__explicitlySet__.add("columnName");
            return this;
        }

        public Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            this.__explicitlySet__.add("columnIndex");
            return this;
        }

        public Builder columnDelimiter(String columnDelimiter) {
            this.columnDelimiter = columnDelimiter;
            this.__explicitlySet__.add("columnDelimiter");
            return this;
        }

        public Builder lineDelimiter(String lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            this.__explicitlySet__.add("lineDelimiter");
            return this;
        }

        public Builder escapeCharacter(String escapeCharacter) {
            this.escapeCharacter = escapeCharacter;
            this.__explicitlySet__.add("escapeCharacter");
            return this;
        }

        public DelimitedFileTypeMetadata build() {
            DelimitedFileTypeMetadata model = new DelimitedFileTypeMetadata(this.columnName, this.columnIndex, this.columnDelimiter, this.lineDelimiter, this.escapeCharacter);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DelimitedFileTypeMetadata model) {
            if (model.wasPropertyExplicitlySet("columnName")) {
                this.columnName(model.getColumnName());
            }
            if (model.wasPropertyExplicitlySet("columnIndex")) {
                this.columnIndex(model.getColumnIndex());
            }
            if (model.wasPropertyExplicitlySet("columnDelimiter")) {
                this.columnDelimiter(model.getColumnDelimiter());
            }
            if (model.wasPropertyExplicitlySet("lineDelimiter")) {
                this.lineDelimiter(model.getLineDelimiter());
            }
            if (model.wasPropertyExplicitlySet("escapeCharacter")) {
                this.escapeCharacter(model.getEscapeCharacter());
            }
            return this;
        }
    }
}

