/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice;

import com.oracle.bmc.datalabelingservice.DataLabelingManagement;
import com.oracle.bmc.datalabelingservice.model.Dataset;
import com.oracle.bmc.datalabelingservice.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GetWorkRequestRequest;
import com.oracle.bmc.datalabelingservice.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DataLabelingManagementWaiters {
    private final ExecutorService executorService;
    private final DataLabelingManagement client;

    public DataLabelingManagementWaiters(ExecutorService executorService, DataLabelingManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDatasetRequest, GetDatasetResponse> forDataset(GetDatasetRequest request, Dataset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataset(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatasetRequest, GetDatasetResponse> forDataset(GetDatasetRequest request, Dataset.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatasetRequest, GetDatasetResponse> forDataset(GetDatasetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Dataset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDataset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatasetRequest, GetDatasetResponse> forDataset(BmcGenericWaiter waiter, GetDatasetRequest request, Dataset.LifecycleState ... targetStates) {
        final HashSet<Dataset.LifecycleState> targetStatesSet = new HashSet<Dataset.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDatasetRequest, GetDatasetResponse>(){

            @Override
            public GetDatasetResponse apply(GetDatasetRequest request) {
                return DataLabelingManagementWaiters.this.client.getDataset(request);
            }
        }, (Predicate)new Predicate<GetDatasetResponse>(){

            @Override
            public boolean test(GetDatasetResponse response) {
                return targetStatesSet.contains((Object)response.getDataset().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Dataset.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataLabelingManagementWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

