/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class StopWorkspaceRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private Long quiesceTimeout;
    private Boolean isForceOperation;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public Long getQuiesceTimeout() {
        return this.quiesceTimeout;
    }

    public Boolean getIsForceOperation() {
        return this.isForceOperation;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).quiesceTimeout(this.quiesceTimeout).isForceOperation(this.isForceOperation).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",quiesceTimeout=").append(String.valueOf(this.quiesceTimeout));
        sb.append(",isForceOperation=").append(String.valueOf(this.isForceOperation));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StopWorkspaceRequest)) {
            return false;
        }
        StopWorkspaceRequest other = (StopWorkspaceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.quiesceTimeout, other.quiesceTimeout) && Objects.equals(this.isForceOperation, other.isForceOperation) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.quiesceTimeout == null ? 43 : this.quiesceTimeout.hashCode());
        result = result * 59 + (this.isForceOperation == null ? 43 : this.isForceOperation.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<StopWorkspaceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private Long quiesceTimeout = null;
        private Boolean isForceOperation = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder quiesceTimeout(Long quiesceTimeout) {
            this.quiesceTimeout = quiesceTimeout;
            return this;
        }

        public Builder isForceOperation(Boolean isForceOperation) {
            this.isForceOperation = isForceOperation;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(StopWorkspaceRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.quiesceTimeout(o.getQuiesceTimeout());
            this.isForceOperation(o.getIsForceOperation());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public StopWorkspaceRequest build() {
            StopWorkspaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public StopWorkspaceRequest buildWithoutInvocationCallback() {
            StopWorkspaceRequest request = new StopWorkspaceRequest();
            request.workspaceId = this.workspaceId;
            request.quiesceTimeout = this.quiesceTimeout;
            request.isForceOperation = this.isForceOperation;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

