/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListTaskRunsRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String opcRequestId;
    private List<String> key;
    private String aggregatorKey;
    private List<String> fields;
    private String name;
    private List<String> identifier;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private List<String> filter;
    private String nameStartsWith;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getKey() {
        return this.key;
    }

    public String getAggregatorKey() {
        return this.aggregatorKey;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdentifier() {
        return this.identifier;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<String> getFilter() {
        return this.filter;
    }

    public String getNameStartsWith() {
        return this.nameStartsWith;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).applicationKey(this.applicationKey).opcRequestId(this.opcRequestId).key(this.key).aggregatorKey(this.aggregatorKey).fields(this.fields).name(this.name).identifier(this.identifier).page(this.page).limit(this.limit).sortOrder(this.sortOrder).sortBy(this.sortBy).filter(this.filter).nameStartsWith(this.nameStartsWith);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",key=").append(String.valueOf(this.key));
        sb.append(",aggregatorKey=").append(String.valueOf(this.aggregatorKey));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",identifier=").append(String.valueOf(this.identifier));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",filter=").append(String.valueOf(this.filter));
        sb.append(",nameStartsWith=").append(String.valueOf(this.nameStartsWith));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTaskRunsRequest)) {
            return false;
        }
        ListTaskRunsRequest other = (ListTaskRunsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.key, other.key) && Objects.equals(this.aggregatorKey, other.aggregatorKey) && Objects.equals(this.fields, other.fields) && Objects.equals(this.name, other.name) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.filter, other.filter) && Objects.equals(this.nameStartsWith, other.nameStartsWith);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.aggregatorKey == null ? 43 : this.aggregatorKey.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.filter == null ? 43 : this.filter.hashCode());
        result = result * 59 + (this.nameStartsWith == null ? 43 : this.nameStartsWith.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTaskRunsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String applicationKey = null;
        private String opcRequestId = null;
        private List<String> key = null;
        private String aggregatorKey = null;
        private List<String> fields = null;
        private String name = null;
        private List<String> identifier = null;
        private String page = null;
        private Integer limit = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private List<String> filter = null;
        private String nameStartsWith = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder key(List<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String singularValue) {
            return this.key(Arrays.asList(singularValue));
        }

        public Builder aggregatorKey(String aggregatorKey) {
            this.aggregatorKey = aggregatorKey;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder identifier(List<String> identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder identifier(String singularValue) {
            return this.identifier(Arrays.asList(singularValue));
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(String singularValue) {
            return this.filter(Arrays.asList(singularValue));
        }

        public Builder nameStartsWith(String nameStartsWith) {
            this.nameStartsWith = nameStartsWith;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTaskRunsRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.opcRequestId(o.getOpcRequestId());
            this.key(o.getKey());
            this.aggregatorKey(o.getAggregatorKey());
            this.fields(o.getFields());
            this.name(o.getName());
            this.identifier(o.getIdentifier());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.filter(o.getFilter());
            this.nameStartsWith(o.getNameStartsWith());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTaskRunsRequest build() {
            ListTaskRunsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListTaskRunsRequest buildWithoutInvocationCallback() {
            ListTaskRunsRequest request = new ListTaskRunsRequest();
            request.workspaceId = this.workspaceId;
            request.applicationKey = this.applicationKey;
            request.opcRequestId = this.opcRequestId;
            request.key = this.key;
            request.aggregatorKey = this.aggregatorKey;
            request.fields = this.fields;
            request.name = this.name;
            request.identifier = this.identifier;
            request.page = this.page;
            request.limit = this.limit;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.filter = this.filter;
            request.nameStartsWith = this.nameStartsWith;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME"),
        TimeUpdated("TIME_UPDATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

