/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetUserDefinedFunctionValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String userDefinedFunctionValidationKey;
    private String opcRequestId;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getUserDefinedFunctionValidationKey() {
        return this.userDefinedFunctionValidationKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).userDefinedFunctionValidationKey(this.userDefinedFunctionValidationKey).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",userDefinedFunctionValidationKey=").append(String.valueOf(this.userDefinedFunctionValidationKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetUserDefinedFunctionValidationRequest)) {
            return false;
        }
        GetUserDefinedFunctionValidationRequest other = (GetUserDefinedFunctionValidationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.userDefinedFunctionValidationKey, other.userDefinedFunctionValidationKey) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.userDefinedFunctionValidationKey == null ? 43 : this.userDefinedFunctionValidationKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetUserDefinedFunctionValidationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String userDefinedFunctionValidationKey = null;
        private String opcRequestId = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder userDefinedFunctionValidationKey(String userDefinedFunctionValidationKey) {
            this.userDefinedFunctionValidationKey = userDefinedFunctionValidationKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetUserDefinedFunctionValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.userDefinedFunctionValidationKey(o.getUserDefinedFunctionValidationKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetUserDefinedFunctionValidationRequest build() {
            GetUserDefinedFunctionValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetUserDefinedFunctionValidationRequest buildWithoutInvocationCallback() {
            GetUserDefinedFunctionValidationRequest request = new GetUserDefinedFunctionValidationRequest();
            request.workspaceId = this.workspaceId;
            request.userDefinedFunctionValidationKey = this.userDefinedFunctionValidationKey;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

