/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPublishedObjectRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String publishedObjectKey;
    private String opcRequestId;
    private String expandReferences;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getPublishedObjectKey() {
        return this.publishedObjectKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getExpandReferences() {
        return this.expandReferences;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).applicationKey(this.applicationKey).publishedObjectKey(this.publishedObjectKey).opcRequestId(this.opcRequestId).expandReferences(this.expandReferences);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(",publishedObjectKey=").append(String.valueOf(this.publishedObjectKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",expandReferences=").append(String.valueOf(this.expandReferences));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPublishedObjectRequest)) {
            return false;
        }
        GetPublishedObjectRequest other = (GetPublishedObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.publishedObjectKey, other.publishedObjectKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.expandReferences, other.expandReferences);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.publishedObjectKey == null ? 43 : this.publishedObjectKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.expandReferences == null ? 43 : this.expandReferences.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPublishedObjectRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String applicationKey = null;
        private String publishedObjectKey = null;
        private String opcRequestId = null;
        private String expandReferences = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder publishedObjectKey(String publishedObjectKey) {
            this.publishedObjectKey = publishedObjectKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder expandReferences(String expandReferences) {
            this.expandReferences = expandReferences;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPublishedObjectRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.publishedObjectKey(o.getPublishedObjectKey());
            this.opcRequestId(o.getOpcRequestId());
            this.expandReferences(o.getExpandReferences());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPublishedObjectRequest build() {
            GetPublishedObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPublishedObjectRequest buildWithoutInvocationCallback() {
            GetPublishedObjectRequest request = new GetPublishedObjectRequest();
            request.workspaceId = this.workspaceId;
            request.applicationKey = this.applicationKey;
            request.publishedObjectKey = this.publishedObjectKey;
            request.opcRequestId = this.opcRequestId;
            request.expandReferences = this.expandReferences;
            return request;
        }
    }
}

