/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateUserDefinedFunctionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateUserDefinedFunctionRequest
extends BmcRequest<CreateUserDefinedFunctionDetails> {
    private String workspaceId;
    private CreateUserDefinedFunctionDetails createUserDefinedFunctionDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateUserDefinedFunctionDetails getCreateUserDefinedFunctionDetails() {
        return this.createUserDefinedFunctionDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateUserDefinedFunctionDetails getBody$() {
        return this.createUserDefinedFunctionDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).createUserDefinedFunctionDetails(this.createUserDefinedFunctionDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",createUserDefinedFunctionDetails=").append(String.valueOf((Object)this.createUserDefinedFunctionDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateUserDefinedFunctionRequest)) {
            return false;
        }
        CreateUserDefinedFunctionRequest other = (CreateUserDefinedFunctionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals((Object)this.createUserDefinedFunctionDetails, (Object)other.createUserDefinedFunctionDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.createUserDefinedFunctionDetails == null ? 43 : this.createUserDefinedFunctionDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateUserDefinedFunctionRequest, CreateUserDefinedFunctionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private CreateUserDefinedFunctionDetails createUserDefinedFunctionDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createUserDefinedFunctionDetails(CreateUserDefinedFunctionDetails createUserDefinedFunctionDetails) {
            this.createUserDefinedFunctionDetails = createUserDefinedFunctionDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateUserDefinedFunctionRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createUserDefinedFunctionDetails(o.getCreateUserDefinedFunctionDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateUserDefinedFunctionRequest build() {
            CreateUserDefinedFunctionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateUserDefinedFunctionDetails body) {
            this.createUserDefinedFunctionDetails(body);
            return this;
        }

        public CreateUserDefinedFunctionRequest buildWithoutInvocationCallback() {
            CreateUserDefinedFunctionRequest request = new CreateUserDefinedFunctionRequest();
            request.workspaceId = this.workspaceId;
            request.createUserDefinedFunctionDetails = this.createUserDefinedFunctionDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

