/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateExternalPublicationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateExternalPublicationRequest
extends BmcRequest<CreateExternalPublicationDetails> {
    private String workspaceId;
    private String taskKey;
    private CreateExternalPublicationDetails createExternalPublicationDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public CreateExternalPublicationDetails getCreateExternalPublicationDetails() {
        return this.createExternalPublicationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateExternalPublicationDetails getBody$() {
        return this.createExternalPublicationDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).taskKey(this.taskKey).createExternalPublicationDetails(this.createExternalPublicationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",taskKey=").append(String.valueOf(this.taskKey));
        sb.append(",createExternalPublicationDetails=").append(String.valueOf((Object)this.createExternalPublicationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateExternalPublicationRequest)) {
            return false;
        }
        CreateExternalPublicationRequest other = (CreateExternalPublicationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.taskKey, other.taskKey) && Objects.equals((Object)this.createExternalPublicationDetails, (Object)other.createExternalPublicationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.taskKey == null ? 43 : this.taskKey.hashCode());
        result = result * 59 + (this.createExternalPublicationDetails == null ? 43 : this.createExternalPublicationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateExternalPublicationRequest, CreateExternalPublicationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String taskKey = null;
        private CreateExternalPublicationDetails createExternalPublicationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder createExternalPublicationDetails(CreateExternalPublicationDetails createExternalPublicationDetails) {
            this.createExternalPublicationDetails = createExternalPublicationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateExternalPublicationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.createExternalPublicationDetails(o.getCreateExternalPublicationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateExternalPublicationRequest build() {
            CreateExternalPublicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateExternalPublicationDetails body) {
            this.createExternalPublicationDetails(body);
            return this;
        }

        public CreateExternalPublicationRequest buildWithoutInvocationCallback() {
            CreateExternalPublicationRequest request = new CreateExternalPublicationRequest();
            request.workspaceId = this.workspaceId;
            request.taskKey = this.taskKey;
            request.createExternalPublicationDetails = this.createExternalPublicationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

