/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractFrequencyDetails;
import com.oracle.bmc.dataintegration.model.Time;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class WeeklyFrequencyDetails
extends AbstractFrequencyDetails {
    @JsonProperty(value="time")
    private final Time time;
    @JsonProperty(value="days")
    private final List<Days> days;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public WeeklyFrequencyDetails(AbstractFrequencyDetails.Frequency frequency, Time time, List<Days> days) {
        super(frequency);
        this.time = time;
        this.days = days;
    }

    public Time getTime() {
        return this.time;
    }

    public List<Days> getDays() {
        return this.days;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WeeklyFrequencyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", time=").append(String.valueOf((Object)this.time));
        sb.append(", days=").append(String.valueOf(this.days));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WeeklyFrequencyDetails)) {
            return false;
        }
        WeeklyFrequencyDetails other = (WeeklyFrequencyDetails)((Object)o);
        return Objects.equals((Object)this.time, (Object)other.time) && Objects.equals(this.days, other.days) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.time == null ? 43 : this.time.hashCode());
        result = result * 59 + (this.days == null ? 43 : this.days.hashCode());
        return result;
    }

    public static enum Days implements BmcEnum
    {
        Sunday("SUNDAY"),
        Monday("MONDAY"),
        Tuesday("TUESDAY"),
        Wednesday("WEDNESDAY"),
        Thursday("THURSDAY"),
        Friday("FRIDAY"),
        Saturday("SATURDAY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Days> map;

        private Days(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Days create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Days', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Days.class);
            map = new HashMap<String, Days>();
            for (Days v : Days.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="frequency")
        private AbstractFrequencyDetails.Frequency frequency;
        @JsonProperty(value="time")
        private Time time;
        @JsonProperty(value="days")
        private List<Days> days;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder frequency(AbstractFrequencyDetails.Frequency frequency) {
            this.frequency = frequency;
            this.__explicitlySet__.add("frequency");
            return this;
        }

        public Builder time(Time time) {
            this.time = time;
            this.__explicitlySet__.add("time");
            return this;
        }

        public Builder days(List<Days> days) {
            this.days = days;
            this.__explicitlySet__.add("days");
            return this;
        }

        public WeeklyFrequencyDetails build() {
            WeeklyFrequencyDetails model = new WeeklyFrequencyDetails(this.frequency, this.time, this.days);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WeeklyFrequencyDetails model) {
            if (model.wasPropertyExplicitlySet("frequency")) {
                this.frequency(model.getFrequency());
            }
            if (model.wasPropertyExplicitlySet("time")) {
                this.time(model.getTime());
            }
            if (model.wasPropertyExplicitlySet("days")) {
                this.days(model.getDays());
            }
            return this;
        }
    }
}

