/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.dataintegration.model.SensitiveAttribute;
import com.oracle.bmc.dataintegration.model.UpdateConnectionFromAtp;
import com.oracle.bmc.dataintegration.model.UpdateDataAssetDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateDataAssetFromAtp
extends UpdateDataAssetDetails {
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="driverClass")
    private final String driverClass;
    @JsonProperty(value="credentialFileContent")
    private final String credentialFileContent;
    @JsonProperty(value="walletSecret")
    private final SensitiveAttribute walletSecret;
    @JsonProperty(value="walletPasswordSecret")
    private final SensitiveAttribute walletPasswordSecret;
    @JsonProperty(value="regionId")
    private final String regionId;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="autonomousDbId")
    private final String autonomousDbId;
    @JsonProperty(value="defaultConnection")
    private final UpdateConnectionFromAtp defaultConnection;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateDataAssetFromAtp(String key, String modelVersion, String name, String description, Integer objectStatus, Integer objectVersion, String identifier, String externalKey, Map<String, String> assetProperties, RegistryMetadata registryMetadata, String serviceName, String driverClass, String credentialFileContent, SensitiveAttribute walletSecret, SensitiveAttribute walletPasswordSecret, String regionId, String tenancyId, String compartmentId, String autonomousDbId, UpdateConnectionFromAtp defaultConnection) {
        super(key, modelVersion, name, description, objectStatus, objectVersion, identifier, externalKey, assetProperties, registryMetadata);
        this.serviceName = serviceName;
        this.driverClass = driverClass;
        this.credentialFileContent = credentialFileContent;
        this.walletSecret = walletSecret;
        this.walletPasswordSecret = walletPasswordSecret;
        this.regionId = regionId;
        this.tenancyId = tenancyId;
        this.compartmentId = compartmentId;
        this.autonomousDbId = autonomousDbId;
        this.defaultConnection = defaultConnection;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getCredentialFileContent() {
        return this.credentialFileContent;
    }

    public SensitiveAttribute getWalletSecret() {
        return this.walletSecret;
    }

    public SensitiveAttribute getWalletPasswordSecret() {
        return this.walletPasswordSecret;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousDbId() {
        return this.autonomousDbId;
    }

    public UpdateConnectionFromAtp getDefaultConnection() {
        return this.defaultConnection;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateDataAssetFromAtp(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", driverClass=").append(String.valueOf(this.driverClass));
        sb.append(", credentialFileContent=").append(String.valueOf(this.credentialFileContent));
        sb.append(", walletSecret=").append(String.valueOf((Object)this.walletSecret));
        sb.append(", walletPasswordSecret=").append(String.valueOf((Object)this.walletPasswordSecret));
        sb.append(", regionId=").append(String.valueOf(this.regionId));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", autonomousDbId=").append(String.valueOf(this.autonomousDbId));
        sb.append(", defaultConnection=").append(String.valueOf((Object)this.defaultConnection));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDataAssetFromAtp)) {
            return false;
        }
        UpdateDataAssetFromAtp other = (UpdateDataAssetFromAtp)((Object)o);
        return Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.driverClass, other.driverClass) && Objects.equals(this.credentialFileContent, other.credentialFileContent) && Objects.equals((Object)this.walletSecret, (Object)other.walletSecret) && Objects.equals((Object)this.walletPasswordSecret, (Object)other.walletPasswordSecret) && Objects.equals(this.regionId, other.regionId) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.autonomousDbId, other.autonomousDbId) && Objects.equals((Object)this.defaultConnection, (Object)other.defaultConnection) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.driverClass == null ? 43 : this.driverClass.hashCode());
        result = result * 59 + (this.credentialFileContent == null ? 43 : this.credentialFileContent.hashCode());
        result = result * 59 + (this.walletSecret == null ? 43 : this.walletSecret.hashCode());
        result = result * 59 + (this.walletPasswordSecret == null ? 43 : this.walletPasswordSecret.hashCode());
        result = result * 59 + (this.regionId == null ? 43 : this.regionId.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.autonomousDbId == null ? 43 : this.autonomousDbId.hashCode());
        result = result * 59 + (this.defaultConnection == null ? 43 : this.defaultConnection.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="assetProperties")
        private Map<String, String> assetProperties;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="driverClass")
        private String driverClass;
        @JsonProperty(value="credentialFileContent")
        private String credentialFileContent;
        @JsonProperty(value="walletSecret")
        private SensitiveAttribute walletSecret;
        @JsonProperty(value="walletPasswordSecret")
        private SensitiveAttribute walletPasswordSecret;
        @JsonProperty(value="regionId")
        private String regionId;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="autonomousDbId")
        private String autonomousDbId;
        @JsonProperty(value="defaultConnection")
        private UpdateConnectionFromAtp defaultConnection;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder assetProperties(Map<String, String> assetProperties) {
            this.assetProperties = assetProperties;
            this.__explicitlySet__.add("assetProperties");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder driverClass(String driverClass) {
            this.driverClass = driverClass;
            this.__explicitlySet__.add("driverClass");
            return this;
        }

        public Builder credentialFileContent(String credentialFileContent) {
            this.credentialFileContent = credentialFileContent;
            this.__explicitlySet__.add("credentialFileContent");
            return this;
        }

        public Builder walletSecret(SensitiveAttribute walletSecret) {
            this.walletSecret = walletSecret;
            this.__explicitlySet__.add("walletSecret");
            return this;
        }

        public Builder walletPasswordSecret(SensitiveAttribute walletPasswordSecret) {
            this.walletPasswordSecret = walletPasswordSecret;
            this.__explicitlySet__.add("walletPasswordSecret");
            return this;
        }

        public Builder regionId(String regionId) {
            this.regionId = regionId;
            this.__explicitlySet__.add("regionId");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder autonomousDbId(String autonomousDbId) {
            this.autonomousDbId = autonomousDbId;
            this.__explicitlySet__.add("autonomousDbId");
            return this;
        }

        public Builder defaultConnection(UpdateConnectionFromAtp defaultConnection) {
            this.defaultConnection = defaultConnection;
            this.__explicitlySet__.add("defaultConnection");
            return this;
        }

        public UpdateDataAssetFromAtp build() {
            UpdateDataAssetFromAtp model = new UpdateDataAssetFromAtp(this.key, this.modelVersion, this.name, this.description, this.objectStatus, this.objectVersion, this.identifier, this.externalKey, this.assetProperties, this.registryMetadata, this.serviceName, this.driverClass, this.credentialFileContent, this.walletSecret, this.walletPasswordSecret, this.regionId, this.tenancyId, this.compartmentId, this.autonomousDbId, this.defaultConnection);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateDataAssetFromAtp model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("externalKey")) {
                this.externalKey(model.getExternalKey());
            }
            if (model.wasPropertyExplicitlySet("assetProperties")) {
                this.assetProperties(model.getAssetProperties());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("driverClass")) {
                this.driverClass(model.getDriverClass());
            }
            if (model.wasPropertyExplicitlySet("credentialFileContent")) {
                this.credentialFileContent(model.getCredentialFileContent());
            }
            if (model.wasPropertyExplicitlySet("walletSecret")) {
                this.walletSecret(model.getWalletSecret());
            }
            if (model.wasPropertyExplicitlySet("walletPasswordSecret")) {
                this.walletPasswordSecret(model.getWalletPasswordSecret());
            }
            if (model.wasPropertyExplicitlySet("regionId")) {
                this.regionId(model.getRegionId());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("autonomousDbId")) {
                this.autonomousDbId(model.getAutonomousDbId());
            }
            if (model.wasPropertyExplicitlySet("defaultConnection")) {
                this.defaultConnection(model.getDefaultConnection());
            }
            return this;
        }
    }
}

