/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateApplicationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="applicationVersion")
    private final Integer applicationVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"key", "modelType", "modelVersion", "name", "description", "applicationVersion", "objectStatus", "identifier", "parentRef", "objectVersion", "metadata", "displayName", "freeformTags", "definedTags", "lifecycleState"})
    public UpdateApplicationDetails(String key, String modelType, String modelVersion, String name, String description, Integer applicationVersion, Integer objectStatus, String identifier, ParentReference parentRef, Integer objectVersion, ObjectMetadata metadata, String displayName, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, LifecycleState lifecycleState) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.name = name;
        this.description = description;
        this.applicationVersion = applicationVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.parentRef = parentRef;
        this.objectVersion = objectVersion;
        this.metadata = metadata;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getApplicationVersion() {
        return this.applicationVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateApplicationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", applicationVersion=").append(String.valueOf(this.applicationVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateApplicationDetails)) {
            return false;
        }
        UpdateApplicationDetails other = (UpdateApplicationDetails)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.applicationVersion, other.applicationVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.applicationVersion == null ? 43 : this.applicationVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="applicationVersion")
        private Integer applicationVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            this.__explicitlySet__.add("applicationVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public UpdateApplicationDetails build() {
            UpdateApplicationDetails model = new UpdateApplicationDetails(this.key, this.modelType, this.modelVersion, this.name, this.description, this.applicationVersion, this.objectStatus, this.identifier, this.parentRef, this.objectVersion, this.metadata, this.displayName, this.freeformTags, this.definedTags, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateApplicationDetails model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("applicationVersion")) {
                this.applicationVersion(model.getApplicationVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

