/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SourceApplicationInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="workspaceId")
    private final String workspaceId;
    @JsonProperty(value="applicationKey")
    private final String applicationKey;
    @JsonProperty(value="applicationVersion")
    private final String applicationVersion;
    @JsonProperty(value="lastPatchKey")
    private final String lastPatchKey;

    @Deprecated
    @ConstructorProperties(value={"workspaceId", "applicationKey", "applicationVersion", "lastPatchKey"})
    public SourceApplicationInfo(String workspaceId, String applicationKey, String applicationVersion, String lastPatchKey) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.applicationVersion = applicationVersion;
        this.lastPatchKey = lastPatchKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getLastPatchKey() {
        return this.lastPatchKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SourceApplicationInfo(");
        sb.append("super=").append(super.toString());
        sb.append("workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(", applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(", applicationVersion=").append(String.valueOf(this.applicationVersion));
        sb.append(", lastPatchKey=").append(String.valueOf(this.lastPatchKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceApplicationInfo)) {
            return false;
        }
        SourceApplicationInfo other = (SourceApplicationInfo)((Object)o);
        return Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.applicationVersion, other.applicationVersion) && Objects.equals(this.lastPatchKey, other.lastPatchKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.applicationVersion == null ? 43 : this.applicationVersion.hashCode());
        result = result * 59 + (this.lastPatchKey == null ? 43 : this.lastPatchKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="workspaceId")
        private String workspaceId;
        @JsonProperty(value="applicationKey")
        private String applicationKey;
        @JsonProperty(value="applicationVersion")
        private String applicationVersion;
        @JsonProperty(value="lastPatchKey")
        private String lastPatchKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            this.__explicitlySet__.add("workspaceId");
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            this.__explicitlySet__.add("applicationKey");
            return this;
        }

        public Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            this.__explicitlySet__.add("applicationVersion");
            return this;
        }

        public Builder lastPatchKey(String lastPatchKey) {
            this.lastPatchKey = lastPatchKey;
            this.__explicitlySet__.add("lastPatchKey");
            return this;
        }

        public SourceApplicationInfo build() {
            SourceApplicationInfo model = new SourceApplicationInfo(this.workspaceId, this.applicationKey, this.applicationVersion, this.lastPatchKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SourceApplicationInfo model) {
            if (model.wasPropertyExplicitlySet("workspaceId")) {
                this.workspaceId(model.getWorkspaceId());
            }
            if (model.wasPropertyExplicitlySet("applicationKey")) {
                this.applicationKey(model.getApplicationKey());
            }
            if (model.wasPropertyExplicitlySet("applicationVersion")) {
                this.applicationVersion(model.getApplicationVersion());
            }
            if (model.wasPropertyExplicitlySet("lastPatchKey")) {
                this.lastPatchKey(model.getLastPatchKey());
            }
            return this;
        }
    }
}

