/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.Pipeline;
import com.oracle.bmc.dataintegration.model.RuntimeOperator;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RuntimePipeline
extends ExplicitlySetBmcModel {
    @JsonProperty(value="pipeline")
    private final Pipeline pipeline;
    @JsonProperty(value="runtimeOperators")
    private final List<RuntimeOperator> runtimeOperators;
    @JsonProperty(value="parentRuntimeOperatorKey")
    private final String parentRuntimeOperatorKey;

    @Deprecated
    @ConstructorProperties(value={"pipeline", "runtimeOperators", "parentRuntimeOperatorKey"})
    public RuntimePipeline(Pipeline pipeline, List<RuntimeOperator> runtimeOperators, String parentRuntimeOperatorKey) {
        this.pipeline = pipeline;
        this.runtimeOperators = runtimeOperators;
        this.parentRuntimeOperatorKey = parentRuntimeOperatorKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public List<RuntimeOperator> getRuntimeOperators() {
        return this.runtimeOperators;
    }

    public String getParentRuntimeOperatorKey() {
        return this.parentRuntimeOperatorKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RuntimePipeline(");
        sb.append("super=").append(super.toString());
        sb.append("pipeline=").append(String.valueOf((Object)this.pipeline));
        sb.append(", runtimeOperators=").append(String.valueOf(this.runtimeOperators));
        sb.append(", parentRuntimeOperatorKey=").append(String.valueOf(this.parentRuntimeOperatorKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuntimePipeline)) {
            return false;
        }
        RuntimePipeline other = (RuntimePipeline)((Object)o);
        return Objects.equals((Object)this.pipeline, (Object)other.pipeline) && Objects.equals(this.runtimeOperators, other.runtimeOperators) && Objects.equals(this.parentRuntimeOperatorKey, other.parentRuntimeOperatorKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.pipeline == null ? 43 : this.pipeline.hashCode());
        result = result * 59 + (this.runtimeOperators == null ? 43 : this.runtimeOperators.hashCode());
        result = result * 59 + (this.parentRuntimeOperatorKey == null ? 43 : this.parentRuntimeOperatorKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="pipeline")
        private Pipeline pipeline;
        @JsonProperty(value="runtimeOperators")
        private List<RuntimeOperator> runtimeOperators;
        @JsonProperty(value="parentRuntimeOperatorKey")
        private String parentRuntimeOperatorKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            this.__explicitlySet__.add("pipeline");
            return this;
        }

        public Builder runtimeOperators(List<RuntimeOperator> runtimeOperators) {
            this.runtimeOperators = runtimeOperators;
            this.__explicitlySet__.add("runtimeOperators");
            return this;
        }

        public Builder parentRuntimeOperatorKey(String parentRuntimeOperatorKey) {
            this.parentRuntimeOperatorKey = parentRuntimeOperatorKey;
            this.__explicitlySet__.add("parentRuntimeOperatorKey");
            return this;
        }

        public RuntimePipeline build() {
            RuntimePipeline model = new RuntimePipeline(this.pipeline, this.runtimeOperators, this.parentRuntimeOperatorKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RuntimePipeline model) {
            if (model.wasPropertyExplicitlySet("pipeline")) {
                this.pipeline(model.getPipeline());
            }
            if (model.wasPropertyExplicitlySet("runtimeOperators")) {
                this.runtimeOperators(model.getRuntimeOperators());
            }
            if (model.wasPropertyExplicitlySet("parentRuntimeOperatorKey")) {
                this.parentRuntimeOperatorKey(model.getParentRuntimeOperatorKey());
            }
            return this;
        }
    }
}

