/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParameterValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RuntimeOperatorSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="taskRunKey")
    private final String taskRunKey;
    @JsonProperty(value="startTimeInMillis")
    private final Long startTimeInMillis;
    @JsonProperty(value="endTimeInMillis")
    private final Long endTimeInMillis;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="executionState")
    private final ExecutionState executionState;
    @JsonProperty(value="parameters")
    private final List<Parameter> parameters;
    @JsonProperty(value="inputs")
    private final Map<String, ParameterValue> inputs;
    @JsonProperty(value="outputs")
    private final Map<String, ParameterValue> outputs;
    @JsonProperty(value="metrics")
    private final Map<String, Float> metrics;

    @Deprecated
    @ConstructorProperties(value={"taskRunKey", "startTimeInMillis", "endTimeInMillis", "status", "executionState", "parameters", "inputs", "outputs", "metrics"})
    public RuntimeOperatorSummary(String taskRunKey, Long startTimeInMillis, Long endTimeInMillis, Status status, ExecutionState executionState, List<Parameter> parameters, Map<String, ParameterValue> inputs, Map<String, ParameterValue> outputs, Map<String, Float> metrics) {
        this.taskRunKey = taskRunKey;
        this.startTimeInMillis = startTimeInMillis;
        this.endTimeInMillis = endTimeInMillis;
        this.status = status;
        this.executionState = executionState;
        this.parameters = parameters;
        this.inputs = inputs;
        this.outputs = outputs;
        this.metrics = metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTaskRunKey() {
        return this.taskRunKey;
    }

    public Long getStartTimeInMillis() {
        return this.startTimeInMillis;
    }

    public Long getEndTimeInMillis() {
        return this.endTimeInMillis;
    }

    public Status getStatus() {
        return this.status;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Map<String, ParameterValue> getInputs() {
        return this.inputs;
    }

    public Map<String, ParameterValue> getOutputs() {
        return this.outputs;
    }

    public Map<String, Float> getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RuntimeOperatorSummary(");
        sb.append("super=").append(super.toString());
        sb.append("taskRunKey=").append(String.valueOf(this.taskRunKey));
        sb.append(", startTimeInMillis=").append(String.valueOf(this.startTimeInMillis));
        sb.append(", endTimeInMillis=").append(String.valueOf(this.endTimeInMillis));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", executionState=").append(String.valueOf((Object)this.executionState));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", inputs=").append(String.valueOf(this.inputs));
        sb.append(", outputs=").append(String.valueOf(this.outputs));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuntimeOperatorSummary)) {
            return false;
        }
        RuntimeOperatorSummary other = (RuntimeOperatorSummary)((Object)o);
        return Objects.equals(this.taskRunKey, other.taskRunKey) && Objects.equals(this.startTimeInMillis, other.startTimeInMillis) && Objects.equals(this.endTimeInMillis, other.endTimeInMillis) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.executionState, (Object)other.executionState) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.inputs, other.inputs) && Objects.equals(this.outputs, other.outputs) && Objects.equals(this.metrics, other.metrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.taskRunKey == null ? 43 : this.taskRunKey.hashCode());
        result = result * 59 + (this.startTimeInMillis == null ? 43 : this.startTimeInMillis.hashCode());
        result = result * 59 + (this.endTimeInMillis == null ? 43 : this.endTimeInMillis.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.executionState == null ? 43 : this.executionState.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.inputs == null ? 43 : this.inputs.hashCode());
        result = result * 59 + (this.outputs == null ? 43 : this.outputs.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExecutionState implements BmcEnum
    {
        NotStarted("NOT_STARTED"),
        Running("RUNNING"),
        Terminated("TERMINATED"),
        Success("SUCCESS"),
        Error("ERROR"),
        Skipped("SKIPPED"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExecutionState> map;

        private ExecutionState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExecutionState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExecutionState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExecutionState.class);
            map = new HashMap<String, ExecutionState>();
            for (ExecutionState v : ExecutionState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        NotStarted("NOT_STARTED"),
        Queued("QUEUED"),
        Running("RUNNING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Success("SUCCESS"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="taskRunKey")
        private String taskRunKey;
        @JsonProperty(value="startTimeInMillis")
        private Long startTimeInMillis;
        @JsonProperty(value="endTimeInMillis")
        private Long endTimeInMillis;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="executionState")
        private ExecutionState executionState;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="inputs")
        private Map<String, ParameterValue> inputs;
        @JsonProperty(value="outputs")
        private Map<String, ParameterValue> outputs;
        @JsonProperty(value="metrics")
        private Map<String, Float> metrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder taskRunKey(String taskRunKey) {
            this.taskRunKey = taskRunKey;
            this.__explicitlySet__.add("taskRunKey");
            return this;
        }

        public Builder startTimeInMillis(Long startTimeInMillis) {
            this.startTimeInMillis = startTimeInMillis;
            this.__explicitlySet__.add("startTimeInMillis");
            return this;
        }

        public Builder endTimeInMillis(Long endTimeInMillis) {
            this.endTimeInMillis = endTimeInMillis;
            this.__explicitlySet__.add("endTimeInMillis");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder executionState(ExecutionState executionState) {
            this.executionState = executionState;
            this.__explicitlySet__.add("executionState");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder inputs(Map<String, ParameterValue> inputs) {
            this.inputs = inputs;
            this.__explicitlySet__.add("inputs");
            return this;
        }

        public Builder outputs(Map<String, ParameterValue> outputs) {
            this.outputs = outputs;
            this.__explicitlySet__.add("outputs");
            return this;
        }

        public Builder metrics(Map<String, Float> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public RuntimeOperatorSummary build() {
            RuntimeOperatorSummary model = new RuntimeOperatorSummary(this.taskRunKey, this.startTimeInMillis, this.endTimeInMillis, this.status, this.executionState, this.parameters, this.inputs, this.outputs, this.metrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RuntimeOperatorSummary model) {
            if (model.wasPropertyExplicitlySet("taskRunKey")) {
                this.taskRunKey(model.getTaskRunKey());
            }
            if (model.wasPropertyExplicitlySet("startTimeInMillis")) {
                this.startTimeInMillis(model.getStartTimeInMillis());
            }
            if (model.wasPropertyExplicitlySet("endTimeInMillis")) {
                this.endTimeInMillis(model.getEndTimeInMillis());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("executionState")) {
                this.executionState(model.getExecutionState());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("inputs")) {
                this.inputs(model.getInputs());
            }
            if (model.wasPropertyExplicitlySet("outputs")) {
                this.outputs(model.getOutputs());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            return this;
        }
    }
}

