/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractFrequencyDetails;
import com.oracle.bmc.dataintegration.model.Time;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class MonthlyFrequencyDetails
extends AbstractFrequencyDetails {
    @JsonProperty(value="interval")
    private final Integer interval;
    @JsonProperty(value="time")
    private final Time time;
    @JsonProperty(value="days")
    private final List<Integer> days;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public MonthlyFrequencyDetails(AbstractFrequencyDetails.Frequency frequency, Integer interval, Time time, List<Integer> days) {
        super(frequency);
        this.interval = interval;
        this.time = time;
        this.days = days;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public Time getTime() {
        return this.time;
    }

    public List<Integer> getDays() {
        return this.days;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonthlyFrequencyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", interval=").append(String.valueOf(this.interval));
        sb.append(", time=").append(String.valueOf((Object)this.time));
        sb.append(", days=").append(String.valueOf(this.days));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonthlyFrequencyDetails)) {
            return false;
        }
        MonthlyFrequencyDetails other = (MonthlyFrequencyDetails)((Object)o);
        return Objects.equals(this.interval, other.interval) && Objects.equals((Object)this.time, (Object)other.time) && Objects.equals(this.days, other.days) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.interval == null ? 43 : this.interval.hashCode());
        result = result * 59 + (this.time == null ? 43 : this.time.hashCode());
        result = result * 59 + (this.days == null ? 43 : this.days.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="frequency")
        private AbstractFrequencyDetails.Frequency frequency;
        @JsonProperty(value="interval")
        private Integer interval;
        @JsonProperty(value="time")
        private Time time;
        @JsonProperty(value="days")
        private List<Integer> days;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder frequency(AbstractFrequencyDetails.Frequency frequency) {
            this.frequency = frequency;
            this.__explicitlySet__.add("frequency");
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.__explicitlySet__.add("interval");
            return this;
        }

        public Builder time(Time time) {
            this.time = time;
            this.__explicitlySet__.add("time");
            return this;
        }

        public Builder days(List<Integer> days) {
            this.days = days;
            this.__explicitlySet__.add("days");
            return this;
        }

        public MonthlyFrequencyDetails build() {
            MonthlyFrequencyDetails model = new MonthlyFrequencyDetails(this.frequency, this.interval, this.time, this.days);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonthlyFrequencyDetails model) {
            if (model.wasPropertyExplicitlySet("frequency")) {
                this.frequency(model.getFrequency());
            }
            if (model.wasPropertyExplicitlySet("interval")) {
                this.interval(model.getInterval());
            }
            if (model.wasPropertyExplicitlySet("time")) {
                this.time(model.getTime());
            }
            if (model.wasPropertyExplicitlySet("days")) {
                this.days(model.getDays());
            }
            return this;
        }
    }
}

