/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.BaseType;
import com.oracle.bmc.dataintegration.model.ConfigDefinition;
import com.oracle.bmc.dataintegration.model.ParentReference;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class MaterializedCompositeType
extends BaseType {
    @JsonProperty(value="elements")
    private final List<String> elements;
    @JsonProperty(value="pathNames")
    private final List<String> pathNames;
    @JsonProperty(value="configDefinition")
    private final ConfigDefinition configDefinition;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public MaterializedCompositeType(String key, String modelVersion, ParentReference parentRef, String name, Integer objectStatus, String description, List<String> elements, List<String> pathNames, ConfigDefinition configDefinition) {
        super(key, modelVersion, parentRef, name, objectStatus, description);
        this.elements = elements;
        this.pathNames = pathNames;
        this.configDefinition = configDefinition;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public List<String> getPathNames() {
        return this.pathNames;
    }

    public ConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaterializedCompositeType(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", elements=").append(String.valueOf(this.elements));
        sb.append(", pathNames=").append(String.valueOf(this.pathNames));
        sb.append(", configDefinition=").append(String.valueOf((Object)this.configDefinition));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaterializedCompositeType)) {
            return false;
        }
        MaterializedCompositeType other = (MaterializedCompositeType)((Object)o);
        return Objects.equals(this.elements, other.elements) && Objects.equals(this.pathNames, other.pathNames) && Objects.equals((Object)this.configDefinition, (Object)other.configDefinition) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.elements == null ? 43 : this.elements.hashCode());
        result = result * 59 + (this.pathNames == null ? 43 : this.pathNames.hashCode());
        result = result * 59 + (this.configDefinition == null ? 43 : this.configDefinition.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="elements")
        private List<String> elements;
        @JsonProperty(value="pathNames")
        private List<String> pathNames;
        @JsonProperty(value="configDefinition")
        private ConfigDefinition configDefinition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder elements(List<String> elements) {
            this.elements = elements;
            this.__explicitlySet__.add("elements");
            return this;
        }

        public Builder pathNames(List<String> pathNames) {
            this.pathNames = pathNames;
            this.__explicitlySet__.add("pathNames");
            return this;
        }

        public Builder configDefinition(ConfigDefinition configDefinition) {
            this.configDefinition = configDefinition;
            this.__explicitlySet__.add("configDefinition");
            return this;
        }

        public MaterializedCompositeType build() {
            MaterializedCompositeType model = new MaterializedCompositeType(this.key, this.modelVersion, this.parentRef, this.name, this.objectStatus, this.description, this.elements, this.pathNames, this.configDefinition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaterializedCompositeType model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("elements")) {
                this.elements(model.getElements());
            }
            if (model.wasPropertyExplicitlySet("pathNames")) {
                this.pathNames(model.getPathNames());
            }
            if (model.wasPropertyExplicitlySet("configDefinition")) {
                this.configDefinition(model.getConfigDefinition());
            }
            return this;
        }
    }
}

