/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.InputLink;
import com.oracle.bmc.dataintegration.model.Operator;
import com.oracle.bmc.dataintegration.model.OutputLink;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.UIProperties;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FlowNode
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="inputLinks")
    private final List<InputLink> inputLinks;
    @JsonProperty(value="outputLinks")
    private final List<OutputLink> outputLinks;
    @JsonProperty(value="operator")
    private final Operator operator;
    @JsonProperty(value="uiProperties")
    private final UIProperties uiProperties;
    @JsonProperty(value="configProviderDelegate")
    private final ConfigProvider configProviderDelegate;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    @Deprecated
    @ConstructorProperties(value={"key", "modelType", "modelVersion", "parentRef", "name", "description", "inputLinks", "outputLinks", "operator", "uiProperties", "configProviderDelegate", "objectStatus"})
    public FlowNode(String key, String modelType, String modelVersion, ParentReference parentRef, String name, String description, List<InputLink> inputLinks, List<OutputLink> outputLinks, Operator operator, UIProperties uiProperties, ConfigProvider configProviderDelegate, Integer objectStatus) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.inputLinks = inputLinks;
        this.outputLinks = outputLinks;
        this.operator = operator;
        this.uiProperties = uiProperties;
        this.configProviderDelegate = configProviderDelegate;
        this.objectStatus = objectStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<InputLink> getInputLinks() {
        return this.inputLinks;
    }

    public List<OutputLink> getOutputLinks() {
        return this.outputLinks;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public UIProperties getUiProperties() {
        return this.uiProperties;
    }

    public ConfigProvider getConfigProviderDelegate() {
        return this.configProviderDelegate;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FlowNode(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", inputLinks=").append(String.valueOf(this.inputLinks));
        sb.append(", outputLinks=").append(String.valueOf(this.outputLinks));
        sb.append(", operator=").append(String.valueOf((Object)this.operator));
        sb.append(", uiProperties=").append(String.valueOf((Object)this.uiProperties));
        sb.append(", configProviderDelegate=").append(String.valueOf((Object)this.configProviderDelegate));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlowNode)) {
            return false;
        }
        FlowNode other = (FlowNode)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.inputLinks, other.inputLinks) && Objects.equals(this.outputLinks, other.outputLinks) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals((Object)this.uiProperties, (Object)other.uiProperties) && Objects.equals((Object)this.configProviderDelegate, (Object)other.configProviderDelegate) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.inputLinks == null ? 43 : this.inputLinks.hashCode());
        result = result * 59 + (this.outputLinks == null ? 43 : this.outputLinks.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        result = result * 59 + (this.uiProperties == null ? 43 : this.uiProperties.hashCode());
        result = result * 59 + (this.configProviderDelegate == null ? 43 : this.configProviderDelegate.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="inputLinks")
        private List<InputLink> inputLinks;
        @JsonProperty(value="outputLinks")
        private List<OutputLink> outputLinks;
        @JsonProperty(value="operator")
        private Operator operator;
        @JsonProperty(value="uiProperties")
        private UIProperties uiProperties;
        @JsonProperty(value="configProviderDelegate")
        private ConfigProvider configProviderDelegate;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder inputLinks(List<InputLink> inputLinks) {
            this.inputLinks = inputLinks;
            this.__explicitlySet__.add("inputLinks");
            return this;
        }

        public Builder outputLinks(List<OutputLink> outputLinks) {
            this.outputLinks = outputLinks;
            this.__explicitlySet__.add("outputLinks");
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Builder uiProperties(UIProperties uiProperties) {
            this.uiProperties = uiProperties;
            this.__explicitlySet__.add("uiProperties");
            return this;
        }

        public Builder configProviderDelegate(ConfigProvider configProviderDelegate) {
            this.configProviderDelegate = configProviderDelegate;
            this.__explicitlySet__.add("configProviderDelegate");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public FlowNode build() {
            FlowNode model = new FlowNode(this.key, this.modelType, this.modelVersion, this.parentRef, this.name, this.description, this.inputLinks, this.outputLinks, this.operator, this.uiProperties, this.configProviderDelegate, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FlowNode model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("inputLinks")) {
                this.inputLinks(model.getInputLinks());
            }
            if (model.wasPropertyExplicitlySet("outputLinks")) {
                this.outputLinks(model.getOutputLinks());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            if (model.wasPropertyExplicitlySet("uiProperties")) {
                this.uiProperties(model.getUiProperties());
            }
            if (model.wasPropertyExplicitlySet("configProviderDelegate")) {
                this.configProviderDelegate(model.getConfigProviderDelegate());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

