/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectorAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalStorage
extends ConnectorAttribute {
    @JsonProperty(value="storageId")
    private final String storageId;
    @JsonProperty(value="storageName")
    private final String storageName;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="bucket")
    private final String bucket;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalStorage(String storageId, String storageName, String host, String tenancyId, String namespace, String bucket) {
        this.storageId = storageId;
        this.storageName = storageName;
        this.host = host;
        this.tenancyId = tenancyId;
        this.namespace = namespace;
        this.bucket = bucket;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public String getHost() {
        return this.host;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getBucket() {
        return this.bucket;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalStorage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", storageId=").append(String.valueOf(this.storageId));
        sb.append(", storageName=").append(String.valueOf(this.storageName));
        sb.append(", host=").append(String.valueOf(this.host));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", bucket=").append(String.valueOf(this.bucket));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalStorage)) {
            return false;
        }
        ExternalStorage other = (ExternalStorage)((Object)o);
        return Objects.equals(this.storageId, other.storageId) && Objects.equals(this.storageName, other.storageName) && Objects.equals(this.host, other.host) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.bucket, other.bucket) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.storageId == null ? 43 : this.storageId.hashCode());
        result = result * 59 + (this.storageName == null ? 43 : this.storageName.hashCode());
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.bucket == null ? 43 : this.bucket.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="storageId")
        private String storageId;
        @JsonProperty(value="storageName")
        private String storageName;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="bucket")
        private String bucket;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder storageId(String storageId) {
            this.storageId = storageId;
            this.__explicitlySet__.add("storageId");
            return this;
        }

        public Builder storageName(String storageName) {
            this.storageName = storageName;
            this.__explicitlySet__.add("storageName");
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            this.__explicitlySet__.add("bucket");
            return this;
        }

        public ExternalStorage build() {
            ExternalStorage model = new ExternalStorage(this.storageId, this.storageName, this.host, this.tenancyId, this.namespace, this.bucket);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalStorage model) {
            if (model.wasPropertyExplicitlySet("storageId")) {
                this.storageId(model.getStorageId());
            }
            if (model.wasPropertyExplicitlySet("storageName")) {
                this.storageName(model.getStorageName());
            }
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("bucket")) {
                this.bucket(model.getBucket());
            }
            return this;
        }
    }
}

