/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigurationDetails;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.ResourceConfiguration;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalPublication
extends ExplicitlySetBmcModel {
    @JsonProperty(value="applicationId")
    private final String applicationId;
    @JsonProperty(value="applicationCompartmentId")
    private final String applicationCompartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="resourceConfiguration")
    private final ResourceConfiguration resourceConfiguration;
    @JsonProperty(value="configurationDetails")
    private final ConfigurationDetails configurationDetails;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="keyMap")
    private final Map<String, String> keyMap;

    @Deprecated
    @ConstructorProperties(value={"applicationId", "applicationCompartmentId", "displayName", "resourceConfiguration", "configurationDetails", "status", "errorMessage", "key", "modelType", "modelVersion", "name", "description", "objectVersion", "objectStatus", "identifier", "parentRef", "metadata", "keyMap"})
    public ExternalPublication(String applicationId, String applicationCompartmentId, String displayName, ResourceConfiguration resourceConfiguration, ConfigurationDetails configurationDetails, Status status, String errorMessage, String key, String modelType, String modelVersion, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, ParentReference parentRef, ObjectMetadata metadata, Map<String, String> keyMap) {
        this.applicationId = applicationId;
        this.applicationCompartmentId = applicationCompartmentId;
        this.displayName = displayName;
        this.resourceConfiguration = resourceConfiguration;
        this.configurationDetails = configurationDetails;
        this.status = status;
        this.errorMessage = errorMessage;
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.parentRef = parentRef;
        this.metadata = metadata;
        this.keyMap = keyMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationCompartmentId() {
        return this.applicationCompartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public ConfigurationDetails getConfigurationDetails() {
        return this.configurationDetails;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getKeyMap() {
        return this.keyMap;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalPublication(");
        sb.append("super=").append(super.toString());
        sb.append("applicationId=").append(String.valueOf(this.applicationId));
        sb.append(", applicationCompartmentId=").append(String.valueOf(this.applicationCompartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", resourceConfiguration=").append(String.valueOf((Object)this.resourceConfiguration));
        sb.append(", configurationDetails=").append(String.valueOf((Object)this.configurationDetails));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", keyMap=").append(String.valueOf(this.keyMap));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalPublication)) {
            return false;
        }
        ExternalPublication other = (ExternalPublication)((Object)o);
        return Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.applicationCompartmentId, other.applicationCompartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.resourceConfiguration, (Object)other.resourceConfiguration) && Objects.equals((Object)this.configurationDetails, (Object)other.configurationDetails) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals(this.keyMap, other.keyMap) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.applicationCompartmentId == null ? 43 : this.applicationCompartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.resourceConfiguration == null ? 43 : this.resourceConfiguration.hashCode());
        result = result * 59 + (this.configurationDetails == null ? 43 : this.configurationDetails.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.keyMap == null ? 43 : this.keyMap.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Successful("SUCCESSFUL"),
        Failed("FAILED"),
        Publishing("PUBLISHING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="applicationId")
        private String applicationId;
        @JsonProperty(value="applicationCompartmentId")
        private String applicationCompartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="resourceConfiguration")
        private ResourceConfiguration resourceConfiguration;
        @JsonProperty(value="configurationDetails")
        private ConfigurationDetails configurationDetails;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="keyMap")
        private Map<String, String> keyMap;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.__explicitlySet__.add("applicationId");
            return this;
        }

        public Builder applicationCompartmentId(String applicationCompartmentId) {
            this.applicationCompartmentId = applicationCompartmentId;
            this.__explicitlySet__.add("applicationCompartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder resourceConfiguration(ResourceConfiguration resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
            this.__explicitlySet__.add("resourceConfiguration");
            return this;
        }

        public Builder configurationDetails(ConfigurationDetails configurationDetails) {
            this.configurationDetails = configurationDetails;
            this.__explicitlySet__.add("configurationDetails");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder keyMap(Map<String, String> keyMap) {
            this.keyMap = keyMap;
            this.__explicitlySet__.add("keyMap");
            return this;
        }

        public ExternalPublication build() {
            ExternalPublication model = new ExternalPublication(this.applicationId, this.applicationCompartmentId, this.displayName, this.resourceConfiguration, this.configurationDetails, this.status, this.errorMessage, this.key, this.modelType, this.modelVersion, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.parentRef, this.metadata, this.keyMap);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalPublication model) {
            if (model.wasPropertyExplicitlySet("applicationId")) {
                this.applicationId(model.getApplicationId());
            }
            if (model.wasPropertyExplicitlySet("applicationCompartmentId")) {
                this.applicationCompartmentId(model.getApplicationCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("resourceConfiguration")) {
                this.resourceConfiguration(model.getResourceConfiguration());
            }
            if (model.wasPropertyExplicitlySet("configurationDetails")) {
                this.configurationDetails(model.getConfigurationDetails());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("keyMap")) {
                this.keyMap(model.getKeyMap());
            }
            return this;
        }
    }
}

