/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.DataEntity;
import com.oracle.bmc.dataintegration.model.DataFormat;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EnrichedEntity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entity")
    private final DataEntity entity;
    @JsonProperty(value="dataFormat")
    private final DataFormat dataFormat;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;

    @Deprecated
    @ConstructorProperties(value={"entity", "dataFormat", "modelType", "parentRef"})
    public EnrichedEntity(DataEntity entity, DataFormat dataFormat, String modelType, ParentReference parentRef) {
        this.entity = entity;
        this.dataFormat = dataFormat;
        this.modelType = modelType;
        this.parentRef = parentRef;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DataEntity getEntity() {
        return this.entity;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public String getModelType() {
        return this.modelType;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EnrichedEntity(");
        sb.append("super=").append(super.toString());
        sb.append("entity=").append(String.valueOf((Object)this.entity));
        sb.append(", dataFormat=").append(String.valueOf((Object)this.dataFormat));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnrichedEntity)) {
            return false;
        }
        EnrichedEntity other = (EnrichedEntity)((Object)o);
        return Objects.equals((Object)this.entity, (Object)other.entity) && Objects.equals((Object)this.dataFormat, (Object)other.dataFormat) && Objects.equals(this.modelType, other.modelType) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entity == null ? 43 : this.entity.hashCode());
        result = result * 59 + (this.dataFormat == null ? 43 : this.dataFormat.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entity")
        private DataEntity entity;
        @JsonProperty(value="dataFormat")
        private DataFormat dataFormat;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entity(DataEntity entity) {
            this.entity = entity;
            this.__explicitlySet__.add("entity");
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            this.__explicitlySet__.add("dataFormat");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public EnrichedEntity build() {
            EnrichedEntity model = new EnrichedEntity(this.entity, this.dataFormat, this.modelType, this.parentRef);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EnrichedEntity model) {
            if (model.wasPropertyExplicitlySet("entity")) {
                this.entity(model.getEntity());
            }
            if (model.wasPropertyExplicitlySet("dataFormat")) {
                this.dataFormat(model.getDataFormat());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            return this;
        }
    }
}

