/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.BaseType;
import com.oracle.bmc.dataintegration.model.ConfigDefinition;
import com.oracle.bmc.dataintegration.model.DynamicTypeHandler;
import com.oracle.bmc.dataintegration.model.ParentReference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class DynamicType
extends BaseType {
    @JsonProperty(value="typeHandler")
    private final DynamicTypeHandler typeHandler;
    @JsonProperty(value="configDefinition")
    private final ConfigDefinition configDefinition;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DynamicType(String key, String modelVersion, ParentReference parentRef, String name, Integer objectStatus, String description, DynamicTypeHandler typeHandler, ConfigDefinition configDefinition) {
        super(key, modelVersion, parentRef, name, objectStatus, description);
        this.typeHandler = typeHandler;
        this.configDefinition = configDefinition;
    }

    public DynamicTypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    public ConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DynamicType(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", typeHandler=").append(String.valueOf((Object)this.typeHandler));
        sb.append(", configDefinition=").append(String.valueOf((Object)this.configDefinition));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicType)) {
            return false;
        }
        DynamicType other = (DynamicType)((Object)o);
        return Objects.equals((Object)this.typeHandler, (Object)other.typeHandler) && Objects.equals((Object)this.configDefinition, (Object)other.configDefinition) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.typeHandler == null ? 43 : this.typeHandler.hashCode());
        result = result * 59 + (this.configDefinition == null ? 43 : this.configDefinition.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="typeHandler")
        private DynamicTypeHandler typeHandler;
        @JsonProperty(value="configDefinition")
        private ConfigDefinition configDefinition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder typeHandler(DynamicTypeHandler typeHandler) {
            this.typeHandler = typeHandler;
            this.__explicitlySet__.add("typeHandler");
            return this;
        }

        public Builder configDefinition(ConfigDefinition configDefinition) {
            this.configDefinition = configDefinition;
            this.__explicitlySet__.add("configDefinition");
            return this;
        }

        public DynamicType build() {
            DynamicType model = new DynamicType(this.key, this.modelVersion, this.parentRef, this.name, this.objectStatus, this.description, this.typeHandler, this.configDefinition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DynamicType model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("typeHandler")) {
                this.typeHandler(model.getTypeHandler());
            }
            if (model.wasPropertyExplicitlySet("configDefinition")) {
                this.configDefinition(model.getConfigDefinition());
            }
            return this;
        }
    }
}

