/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.FlowNode;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Variable;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreatePipelineValidationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="nodes")
    private final List<FlowNode> nodes;
    @JsonProperty(value="parameters")
    private final List<Parameter> parameters;
    @JsonProperty(value="flowConfigValues")
    private final ConfigValues flowConfigValues;
    @JsonProperty(value="variables")
    private final List<Variable> variables;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "modelType", "objectVersion", "objectStatus", "identifier", "nodes", "parameters", "flowConfigValues", "variables", "metadata"})
    public CreatePipelineValidationDetails(String key, String modelVersion, ParentReference parentRef, String name, String description, String modelType, Integer objectVersion, Integer objectStatus, String identifier, List<FlowNode> nodes, List<Parameter> parameters, ConfigValues flowConfigValues, List<Variable> variables, ObjectMetadata metadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.modelType = modelType;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.nodes = nodes;
        this.parameters = parameters;
        this.flowConfigValues = flowConfigValues;
        this.variables = variables;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<FlowNode> getNodes() {
        return this.nodes;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public ConfigValues getFlowConfigValues() {
        return this.flowConfigValues;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreatePipelineValidationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", nodes=").append(String.valueOf(this.nodes));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", flowConfigValues=").append(String.valueOf((Object)this.flowConfigValues));
        sb.append(", variables=").append(String.valueOf(this.variables));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePipelineValidationDetails)) {
            return false;
        }
        CreatePipelineValidationDetails other = (CreatePipelineValidationDetails)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.parameters, other.parameters) && Objects.equals((Object)this.flowConfigValues, (Object)other.flowConfigValues) && Objects.equals(this.variables, other.variables) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.nodes == null ? 43 : this.nodes.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.flowConfigValues == null ? 43 : this.flowConfigValues.hashCode());
        result = result * 59 + (this.variables == null ? 43 : this.variables.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="nodes")
        private List<FlowNode> nodes;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="flowConfigValues")
        private ConfigValues flowConfigValues;
        @JsonProperty(value="variables")
        private List<Variable> variables;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder nodes(List<FlowNode> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder flowConfigValues(ConfigValues flowConfigValues) {
            this.flowConfigValues = flowConfigValues;
            this.__explicitlySet__.add("flowConfigValues");
            return this;
        }

        public Builder variables(List<Variable> variables) {
            this.variables = variables;
            this.__explicitlySet__.add("variables");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public CreatePipelineValidationDetails build() {
            CreatePipelineValidationDetails model = new CreatePipelineValidationDetails(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.modelType, this.objectVersion, this.objectStatus, this.identifier, this.nodes, this.parameters, this.flowConfigValues, this.variables, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreatePipelineValidationDetails model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("nodes")) {
                this.nodes(model.getNodes());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("flowConfigValues")) {
                this.flowConfigValues(model.getFlowConfigValues());
            }
            if (model.wasPropertyExplicitlySet("variables")) {
                this.variables(model.getVariables());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

