/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromObjectStorage;
import com.oracle.bmc.dataintegration.model.CreateDataAssetDetails;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateDataAssetFromObjectStorage
extends CreateDataAssetDetails {
    @JsonProperty(value="ociRegion")
    private final String ociRegion;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="defaultConnection")
    private final CreateConnectionFromObjectStorage defaultConnection;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateDataAssetFromObjectStorage(String key, String modelVersion, String name, String description, Integer objectStatus, String identifier, String externalKey, Map<String, String> assetProperties, RegistryMetadata registryMetadata, String ociRegion, String url, String tenancyId, String namespace, CreateConnectionFromObjectStorage defaultConnection) {
        super(key, modelVersion, name, description, objectStatus, identifier, externalKey, assetProperties, registryMetadata);
        this.ociRegion = ociRegion;
        this.url = url;
        this.tenancyId = tenancyId;
        this.namespace = namespace;
        this.defaultConnection = defaultConnection;
    }

    public String getOciRegion() {
        return this.ociRegion;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CreateConnectionFromObjectStorage getDefaultConnection() {
        return this.defaultConnection;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDataAssetFromObjectStorage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", ociRegion=").append(String.valueOf(this.ociRegion));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", defaultConnection=").append(String.valueOf((Object)this.defaultConnection));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataAssetFromObjectStorage)) {
            return false;
        }
        CreateDataAssetFromObjectStorage other = (CreateDataAssetFromObjectStorage)((Object)o);
        return Objects.equals(this.ociRegion, other.ociRegion) && Objects.equals(this.url, other.url) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.namespace, other.namespace) && Objects.equals((Object)this.defaultConnection, (Object)other.defaultConnection) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ociRegion == null ? 43 : this.ociRegion.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.defaultConnection == null ? 43 : this.defaultConnection.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="assetProperties")
        private Map<String, String> assetProperties;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonProperty(value="ociRegion")
        private String ociRegion;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="defaultConnection")
        private CreateConnectionFromObjectStorage defaultConnection;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder assetProperties(Map<String, String> assetProperties) {
            this.assetProperties = assetProperties;
            this.__explicitlySet__.add("assetProperties");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public Builder ociRegion(String ociRegion) {
            this.ociRegion = ociRegion;
            this.__explicitlySet__.add("ociRegion");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder defaultConnection(CreateConnectionFromObjectStorage defaultConnection) {
            this.defaultConnection = defaultConnection;
            this.__explicitlySet__.add("defaultConnection");
            return this;
        }

        public CreateDataAssetFromObjectStorage build() {
            CreateDataAssetFromObjectStorage model = new CreateDataAssetFromObjectStorage(this.key, this.modelVersion, this.name, this.description, this.objectStatus, this.identifier, this.externalKey, this.assetProperties, this.registryMetadata, this.ociRegion, this.url, this.tenancyId, this.namespace, this.defaultConnection);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDataAssetFromObjectStorage model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("externalKey")) {
                this.externalKey(model.getExternalKey());
            }
            if (model.wasPropertyExplicitlySet("assetProperties")) {
                this.assetProperties(model.getAssetProperties());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            if (model.wasPropertyExplicitlySet("ociRegion")) {
                this.ociRegion(model.getOciRegion());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("defaultConnection")) {
                this.defaultConnection(model.getDefaultConnection());
            }
            return this;
        }
    }
}

