/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.ConnectionSummary;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schema;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionSummaryFromObjectStorage
extends ConnectionSummary {
    @JsonProperty(value="credentialFileContent")
    private final String credentialFileContent;
    @JsonProperty(value="userId")
    private final String userId;
    @JsonProperty(value="fingerPrint")
    private final String fingerPrint;
    @JsonProperty(value="passPhrase")
    private final String passPhrase;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ConnectionSummaryFromObjectStorage(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schema primarySchema, List<ConnectionProperty> connectionProperties, Boolean isDefault, ObjectMetadata metadata, Map<String, String> keyMap, String credentialFileContent, String userId, String fingerPrint, String passPhrase) {
        super(key, modelVersion, parentRef, name, description, objectVersion, objectStatus, identifier, primarySchema, connectionProperties, isDefault, metadata, keyMap);
        this.credentialFileContent = credentialFileContent;
        this.userId = userId;
        this.fingerPrint = fingerPrint;
        this.passPhrase = passPhrase;
    }

    public String getCredentialFileContent() {
        return this.credentialFileContent;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionSummaryFromObjectStorage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", credentialFileContent=").append(String.valueOf(this.credentialFileContent));
        sb.append(", userId=").append(String.valueOf(this.userId));
        sb.append(", fingerPrint=").append(String.valueOf(this.fingerPrint));
        sb.append(", passPhrase=").append(String.valueOf(this.passPhrase));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionSummaryFromObjectStorage)) {
            return false;
        }
        ConnectionSummaryFromObjectStorage other = (ConnectionSummaryFromObjectStorage)((Object)o);
        return Objects.equals(this.credentialFileContent, other.credentialFileContent) && Objects.equals(this.userId, other.userId) && Objects.equals(this.fingerPrint, other.fingerPrint) && Objects.equals(this.passPhrase, other.passPhrase) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.credentialFileContent == null ? 43 : this.credentialFileContent.hashCode());
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.fingerPrint == null ? 43 : this.fingerPrint.hashCode());
        result = result * 59 + (this.passPhrase == null ? 43 : this.passPhrase.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="primarySchema")
        private Schema primarySchema;
        @JsonProperty(value="connectionProperties")
        private List<ConnectionProperty> connectionProperties;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="keyMap")
        private Map<String, String> keyMap;
        @JsonProperty(value="credentialFileContent")
        private String credentialFileContent;
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="fingerPrint")
        private String fingerPrint;
        @JsonProperty(value="passPhrase")
        private String passPhrase;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder primarySchema(Schema primarySchema) {
            this.primarySchema = primarySchema;
            this.__explicitlySet__.add("primarySchema");
            return this;
        }

        public Builder connectionProperties(List<ConnectionProperty> connectionProperties) {
            this.connectionProperties = connectionProperties;
            this.__explicitlySet__.add("connectionProperties");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder keyMap(Map<String, String> keyMap) {
            this.keyMap = keyMap;
            this.__explicitlySet__.add("keyMap");
            return this;
        }

        public Builder credentialFileContent(String credentialFileContent) {
            this.credentialFileContent = credentialFileContent;
            this.__explicitlySet__.add("credentialFileContent");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.__explicitlySet__.add("userId");
            return this;
        }

        public Builder fingerPrint(String fingerPrint) {
            this.fingerPrint = fingerPrint;
            this.__explicitlySet__.add("fingerPrint");
            return this;
        }

        public Builder passPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
            this.__explicitlySet__.add("passPhrase");
            return this;
        }

        public ConnectionSummaryFromObjectStorage build() {
            ConnectionSummaryFromObjectStorage model = new ConnectionSummaryFromObjectStorage(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.primarySchema, this.connectionProperties, this.isDefault, this.metadata, this.keyMap, this.credentialFileContent, this.userId, this.fingerPrint, this.passPhrase);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionSummaryFromObjectStorage model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("primarySchema")) {
                this.primarySchema(model.getPrimarySchema());
            }
            if (model.wasPropertyExplicitlySet("connectionProperties")) {
                this.connectionProperties(model.getConnectionProperties());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("keyMap")) {
                this.keyMap(model.getKeyMap());
            }
            if (model.wasPropertyExplicitlySet("credentialFileContent")) {
                this.credentialFileContent(model.getCredentialFileContent());
            }
            if (model.wasPropertyExplicitlySet("userId")) {
                this.userId(model.getUserId());
            }
            if (model.wasPropertyExplicitlySet("fingerPrint")) {
                this.fingerPrint(model.getFingerPrint());
            }
            if (model.wasPropertyExplicitlySet("passPhrase")) {
                this.passPhrase(model.getPassPhrase());
            }
            return this;
        }
    }
}

