/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataintegration.DataIntegrationAsync;
import com.oracle.bmc.dataintegration.model.Application;
import com.oracle.bmc.dataintegration.model.ApplicationSummaryCollection;
import com.oracle.bmc.dataintegration.model.Connection;
import com.oracle.bmc.dataintegration.model.ConnectionSummaryCollection;
import com.oracle.bmc.dataintegration.model.ConnectionValidation;
import com.oracle.bmc.dataintegration.model.ConnectionValidationSummaryCollection;
import com.oracle.bmc.dataintegration.model.CountStatistic;
import com.oracle.bmc.dataintegration.model.DataAsset;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryCollection;
import com.oracle.bmc.dataintegration.model.DataEntity;
import com.oracle.bmc.dataintegration.model.DataEntitySummaryCollection;
import com.oracle.bmc.dataintegration.model.DataFlow;
import com.oracle.bmc.dataintegration.model.DataFlowSummaryCollection;
import com.oracle.bmc.dataintegration.model.DataFlowValidation;
import com.oracle.bmc.dataintegration.model.DataFlowValidationSummaryCollection;
import com.oracle.bmc.dataintegration.model.DependentObject;
import com.oracle.bmc.dataintegration.model.DependentObjectSummaryCollection;
import com.oracle.bmc.dataintegration.model.DisApplication;
import com.oracle.bmc.dataintegration.model.DisApplicationSummaryCollection;
import com.oracle.bmc.dataintegration.model.EntityShape;
import com.oracle.bmc.dataintegration.model.ExternalPublication;
import com.oracle.bmc.dataintegration.model.ExternalPublicationSummaryCollection;
import com.oracle.bmc.dataintegration.model.ExternalPublicationValidation;
import com.oracle.bmc.dataintegration.model.ExternalPublicationValidationSummaryCollection;
import com.oracle.bmc.dataintegration.model.Folder;
import com.oracle.bmc.dataintegration.model.FolderSummaryCollection;
import com.oracle.bmc.dataintegration.model.FunctionLibrary;
import com.oracle.bmc.dataintegration.model.FunctionLibrarySummaryCollection;
import com.oracle.bmc.dataintegration.model.Patch;
import com.oracle.bmc.dataintegration.model.PatchChangeSummaryCollection;
import com.oracle.bmc.dataintegration.model.PatchSummaryCollection;
import com.oracle.bmc.dataintegration.model.Pipeline;
import com.oracle.bmc.dataintegration.model.PipelineSummaryCollection;
import com.oracle.bmc.dataintegration.model.PipelineValidation;
import com.oracle.bmc.dataintegration.model.PipelineValidationSummaryCollection;
import com.oracle.bmc.dataintegration.model.Project;
import com.oracle.bmc.dataintegration.model.ProjectSummaryCollection;
import com.oracle.bmc.dataintegration.model.PublishedObject;
import com.oracle.bmc.dataintegration.model.PublishedObjectSummaryCollection;
import com.oracle.bmc.dataintegration.model.Reference;
import com.oracle.bmc.dataintegration.model.ReferenceSummaryCollection;
import com.oracle.bmc.dataintegration.model.RuntimeOperator;
import com.oracle.bmc.dataintegration.model.RuntimeOperatorSummaryCollection;
import com.oracle.bmc.dataintegration.model.RuntimePipeline;
import com.oracle.bmc.dataintegration.model.RuntimePipelineSummaryCollection;
import com.oracle.bmc.dataintegration.model.Schedule;
import com.oracle.bmc.dataintegration.model.ScheduleSummaryCollection;
import com.oracle.bmc.dataintegration.model.Schema;
import com.oracle.bmc.dataintegration.model.SchemaSummaryCollection;
import com.oracle.bmc.dataintegration.model.Task;
import com.oracle.bmc.dataintegration.model.TaskRun;
import com.oracle.bmc.dataintegration.model.TaskRunDetails;
import com.oracle.bmc.dataintegration.model.TaskRunLineageSummaryCollection;
import com.oracle.bmc.dataintegration.model.TaskRunLogSummary;
import com.oracle.bmc.dataintegration.model.TaskRunSummaryCollection;
import com.oracle.bmc.dataintegration.model.TaskSchedule;
import com.oracle.bmc.dataintegration.model.TaskScheduleSummaryCollection;
import com.oracle.bmc.dataintegration.model.TaskSummaryCollection;
import com.oracle.bmc.dataintegration.model.TaskValidation;
import com.oracle.bmc.dataintegration.model.TaskValidationSummaryCollection;
import com.oracle.bmc.dataintegration.model.UserDefinedFunction;
import com.oracle.bmc.dataintegration.model.UserDefinedFunctionSummaryCollection;
import com.oracle.bmc.dataintegration.model.UserDefinedFunctionValidation;
import com.oracle.bmc.dataintegration.model.UserDefinedFunctionValidationSummaryCollection;
import com.oracle.bmc.dataintegration.model.WorkRequest;
import com.oracle.bmc.dataintegration.model.WorkRequestError;
import com.oracle.bmc.dataintegration.model.WorkRequestLogEntry;
import com.oracle.bmc.dataintegration.model.WorkRequestSummary;
import com.oracle.bmc.dataintegration.model.Workspace;
import com.oracle.bmc.dataintegration.model.WorkspaceSummary;
import com.oracle.bmc.dataintegration.requests.ChangeCompartmentRequest;
import com.oracle.bmc.dataintegration.requests.ChangeDisApplicationCompartmentRequest;
import com.oracle.bmc.dataintegration.requests.CreateApplicationRequest;
import com.oracle.bmc.dataintegration.requests.CreateConnectionRequest;
import com.oracle.bmc.dataintegration.requests.CreateConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateDisApplicationRequest;
import com.oracle.bmc.dataintegration.requests.CreateEntityShapeRequest;
import com.oracle.bmc.dataintegration.requests.CreateExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.CreateExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateFolderRequest;
import com.oracle.bmc.dataintegration.requests.CreateFunctionLibraryRequest;
import com.oracle.bmc.dataintegration.requests.CreatePatchRequest;
import com.oracle.bmc.dataintegration.requests.CreatePipelineRequest;
import com.oracle.bmc.dataintegration.requests.CreatePipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateProjectRequest;
import com.oracle.bmc.dataintegration.requests.CreateScheduleRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskScheduleRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateUserDefinedFunctionRequest;
import com.oracle.bmc.dataintegration.requests.CreateUserDefinedFunctionValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteConnectionRequest;
import com.oracle.bmc.dataintegration.requests.DeleteConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDisApplicationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteFolderRequest;
import com.oracle.bmc.dataintegration.requests.DeleteFunctionLibraryRequest;
import com.oracle.bmc.dataintegration.requests.DeletePatchRequest;
import com.oracle.bmc.dataintegration.requests.DeletePipelineRequest;
import com.oracle.bmc.dataintegration.requests.DeletePipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteProjectRequest;
import com.oracle.bmc.dataintegration.requests.DeleteScheduleRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskScheduleRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteUserDefinedFunctionRequest;
import com.oracle.bmc.dataintegration.requests.DeleteUserDefinedFunctionValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.GetApplicationRequest;
import com.oracle.bmc.dataintegration.requests.GetConnectionRequest;
import com.oracle.bmc.dataintegration.requests.GetConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetCountStatisticRequest;
import com.oracle.bmc.dataintegration.requests.GetDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.GetDataEntityRequest;
import com.oracle.bmc.dataintegration.requests.GetDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.GetDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetDependentObjectRequest;
import com.oracle.bmc.dataintegration.requests.GetDisApplicationRequest;
import com.oracle.bmc.dataintegration.requests.GetExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.GetExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetFolderRequest;
import com.oracle.bmc.dataintegration.requests.GetFunctionLibraryRequest;
import com.oracle.bmc.dataintegration.requests.GetPatchRequest;
import com.oracle.bmc.dataintegration.requests.GetPipelineRequest;
import com.oracle.bmc.dataintegration.requests.GetPipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetProjectRequest;
import com.oracle.bmc.dataintegration.requests.GetPublishedObjectRequest;
import com.oracle.bmc.dataintegration.requests.GetReferenceRequest;
import com.oracle.bmc.dataintegration.requests.GetRuntimeOperatorRequest;
import com.oracle.bmc.dataintegration.requests.GetRuntimePipelineRequest;
import com.oracle.bmc.dataintegration.requests.GetScheduleRequest;
import com.oracle.bmc.dataintegration.requests.GetSchemaRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskScheduleRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetUserDefinedFunctionRequest;
import com.oracle.bmc.dataintegration.requests.GetUserDefinedFunctionValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.ListApplicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListConnectionValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListConnectionsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataAssetsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataEntitiesRequest;
import com.oracle.bmc.dataintegration.requests.ListDataFlowValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataFlowsRequest;
import com.oracle.bmc.dataintegration.requests.ListDependentObjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListDisApplicationTaskRunLineagesRequest;
import com.oracle.bmc.dataintegration.requests.ListDisApplicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListExternalPublicationValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListExternalPublicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListFoldersRequest;
import com.oracle.bmc.dataintegration.requests.ListFunctionLibrariesRequest;
import com.oracle.bmc.dataintegration.requests.ListPatchChangesRequest;
import com.oracle.bmc.dataintegration.requests.ListPatchesRequest;
import com.oracle.bmc.dataintegration.requests.ListPipelineValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListPipelinesRequest;
import com.oracle.bmc.dataintegration.requests.ListProjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListPublishedObjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListReferencesRequest;
import com.oracle.bmc.dataintegration.requests.ListRuntimeOperatorsRequest;
import com.oracle.bmc.dataintegration.requests.ListRuntimePipelinesRequest;
import com.oracle.bmc.dataintegration.requests.ListSchedulesRequest;
import com.oracle.bmc.dataintegration.requests.ListSchemasRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunLineagesRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunLogsRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunsRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskSchedulesRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListTasksRequest;
import com.oracle.bmc.dataintegration.requests.ListUserDefinedFunctionValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListUserDefinedFunctionsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkspacesRequest;
import com.oracle.bmc.dataintegration.requests.StartWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.StopWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataintegration.requests.UpdateConnectionRequest;
import com.oracle.bmc.dataintegration.requests.UpdateDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.UpdateDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.UpdateDisApplicationRequest;
import com.oracle.bmc.dataintegration.requests.UpdateExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.UpdateFolderRequest;
import com.oracle.bmc.dataintegration.requests.UpdateFunctionLibraryRequest;
import com.oracle.bmc.dataintegration.requests.UpdatePipelineRequest;
import com.oracle.bmc.dataintegration.requests.UpdateProjectRequest;
import com.oracle.bmc.dataintegration.requests.UpdateReferenceRequest;
import com.oracle.bmc.dataintegration.requests.UpdateScheduleRequest;
import com.oracle.bmc.dataintegration.requests.UpdateTaskRequest;
import com.oracle.bmc.dataintegration.requests.UpdateTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.UpdateTaskScheduleRequest;
import com.oracle.bmc.dataintegration.requests.UpdateUserDefinedFunctionRequest;
import com.oracle.bmc.dataintegration.requests.UpdateWorkspaceRequest;
import com.oracle.bmc.dataintegration.responses.ChangeCompartmentResponse;
import com.oracle.bmc.dataintegration.responses.ChangeDisApplicationCompartmentResponse;
import com.oracle.bmc.dataintegration.responses.CreateApplicationResponse;
import com.oracle.bmc.dataintegration.responses.CreateConnectionResponse;
import com.oracle.bmc.dataintegration.responses.CreateConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateDisApplicationResponse;
import com.oracle.bmc.dataintegration.responses.CreateEntityShapeResponse;
import com.oracle.bmc.dataintegration.responses.CreateExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.CreateExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateFolderResponse;
import com.oracle.bmc.dataintegration.responses.CreateFunctionLibraryResponse;
import com.oracle.bmc.dataintegration.responses.CreatePatchResponse;
import com.oracle.bmc.dataintegration.responses.CreatePipelineResponse;
import com.oracle.bmc.dataintegration.responses.CreatePipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateProjectResponse;
import com.oracle.bmc.dataintegration.responses.CreateScheduleResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskScheduleResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateUserDefinedFunctionResponse;
import com.oracle.bmc.dataintegration.responses.CreateUserDefinedFunctionValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteConnectionResponse;
import com.oracle.bmc.dataintegration.responses.DeleteConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDisApplicationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteFolderResponse;
import com.oracle.bmc.dataintegration.responses.DeleteFunctionLibraryResponse;
import com.oracle.bmc.dataintegration.responses.DeletePatchResponse;
import com.oracle.bmc.dataintegration.responses.DeletePipelineResponse;
import com.oracle.bmc.dataintegration.responses.DeletePipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteProjectResponse;
import com.oracle.bmc.dataintegration.responses.DeleteScheduleResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskScheduleResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteUserDefinedFunctionResponse;
import com.oracle.bmc.dataintegration.responses.DeleteUserDefinedFunctionValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.GetApplicationResponse;
import com.oracle.bmc.dataintegration.responses.GetConnectionResponse;
import com.oracle.bmc.dataintegration.responses.GetConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetCountStatisticResponse;
import com.oracle.bmc.dataintegration.responses.GetDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.GetDataEntityResponse;
import com.oracle.bmc.dataintegration.responses.GetDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.GetDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetDependentObjectResponse;
import com.oracle.bmc.dataintegration.responses.GetDisApplicationResponse;
import com.oracle.bmc.dataintegration.responses.GetExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.GetExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetFolderResponse;
import com.oracle.bmc.dataintegration.responses.GetFunctionLibraryResponse;
import com.oracle.bmc.dataintegration.responses.GetPatchResponse;
import com.oracle.bmc.dataintegration.responses.GetPipelineResponse;
import com.oracle.bmc.dataintegration.responses.GetPipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetProjectResponse;
import com.oracle.bmc.dataintegration.responses.GetPublishedObjectResponse;
import com.oracle.bmc.dataintegration.responses.GetReferenceResponse;
import com.oracle.bmc.dataintegration.responses.GetRuntimeOperatorResponse;
import com.oracle.bmc.dataintegration.responses.GetRuntimePipelineResponse;
import com.oracle.bmc.dataintegration.responses.GetScheduleResponse;
import com.oracle.bmc.dataintegration.responses.GetSchemaResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskScheduleResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetUserDefinedFunctionResponse;
import com.oracle.bmc.dataintegration.responses.GetUserDefinedFunctionValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.ListApplicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListConnectionValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListConnectionsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataAssetsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataEntitiesResponse;
import com.oracle.bmc.dataintegration.responses.ListDataFlowValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataFlowsResponse;
import com.oracle.bmc.dataintegration.responses.ListDependentObjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListDisApplicationTaskRunLineagesResponse;
import com.oracle.bmc.dataintegration.responses.ListDisApplicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListExternalPublicationValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListExternalPublicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListFoldersResponse;
import com.oracle.bmc.dataintegration.responses.ListFunctionLibrariesResponse;
import com.oracle.bmc.dataintegration.responses.ListPatchChangesResponse;
import com.oracle.bmc.dataintegration.responses.ListPatchesResponse;
import com.oracle.bmc.dataintegration.responses.ListPipelineValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListPipelinesResponse;
import com.oracle.bmc.dataintegration.responses.ListProjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListPublishedObjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListReferencesResponse;
import com.oracle.bmc.dataintegration.responses.ListRuntimeOperatorsResponse;
import com.oracle.bmc.dataintegration.responses.ListRuntimePipelinesResponse;
import com.oracle.bmc.dataintegration.responses.ListSchedulesResponse;
import com.oracle.bmc.dataintegration.responses.ListSchemasResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunLineagesResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunLogsResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunsResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskSchedulesResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListTasksResponse;
import com.oracle.bmc.dataintegration.responses.ListUserDefinedFunctionValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListUserDefinedFunctionsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkspacesResponse;
import com.oracle.bmc.dataintegration.responses.StartWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.StopWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataintegration.responses.UpdateConnectionResponse;
import com.oracle.bmc.dataintegration.responses.UpdateDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.UpdateDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.UpdateDisApplicationResponse;
import com.oracle.bmc.dataintegration.responses.UpdateExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.UpdateFolderResponse;
import com.oracle.bmc.dataintegration.responses.UpdateFunctionLibraryResponse;
import com.oracle.bmc.dataintegration.responses.UpdatePipelineResponse;
import com.oracle.bmc.dataintegration.responses.UpdateProjectResponse;
import com.oracle.bmc.dataintegration.responses.UpdateReferenceResponse;
import com.oracle.bmc.dataintegration.responses.UpdateScheduleResponse;
import com.oracle.bmc.dataintegration.responses.UpdateTaskResponse;
import com.oracle.bmc.dataintegration.responses.UpdateTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.UpdateTaskScheduleResponse;
import com.oracle.bmc.dataintegration.responses.UpdateUserDefinedFunctionResponse;
import com.oracle.bmc.dataintegration.responses.UpdateWorkspaceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIntegrationAsyncClient
extends BaseAsyncClient
implements DataIntegrationAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATAINTEGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataintegration.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataIntegrationAsyncClient.class);

    private DataIntegrationAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeCompartmentResponse> changeCompartment(ChangeCompartmentRequest request, AsyncHandler<ChangeCompartmentRequest, ChangeCompartmentResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCompartmentDetails(), "changeCompartmentDetails is required");
        return this.clientCall(request, ChangeCompartmentResponse::builder).logger(LOG, "changeCompartment").serviceDetails("DataIntegration", "ChangeCompartment", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Workspace/ChangeCompartment").method(Method.POST).requestBuilder(ChangeCompartmentRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDisApplicationCompartmentResponse> changeDisApplicationCompartment(ChangeDisApplicationCompartmentRequest request, AsyncHandler<ChangeDisApplicationCompartmentRequest, ChangeDisApplicationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDisApplicationId(), (String)"disApplicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDisApplicationCompartmentDetails(), "changeDisApplicationCompartmentDetails is required");
        return this.clientCall(request, ChangeDisApplicationCompartmentResponse::builder).logger(LOG, "changeDisApplicationCompartment").serviceDetails("DataIntegration", "ChangeDisApplicationCompartment", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DisApplication/ChangeDisApplicationCompartment").method(Method.POST).requestBuilder(ChangeDisApplicationCompartmentRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("disApplications").appendPathParam(request.getDisApplicationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDisApplicationCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeDisApplicationCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateApplicationResponse> createApplication(CreateApplicationRequest request, AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateApplicationDetails(), "createApplicationDetails is required");
        return this.clientCall(request, CreateApplicationResponse::builder).logger(LOG, "createApplication").serviceDetails("DataIntegration", "CreateApplication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/CreateApplication").method(Method.POST).requestBuilder(CreateApplicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Application.class, CreateApplicationResponse.Builder::application).handleResponseHeaderString("etag", CreateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateConnectionResponse> createConnection(CreateConnectionRequest request, AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("DataIntegration", "CreateConnection", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Connection/CreateConnection").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateConnectionValidationResponse> createConnectionValidation(CreateConnectionValidationRequest request, AsyncHandler<CreateConnectionValidationRequest, CreateConnectionValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateConnectionValidationDetails(), "createConnectionValidationDetails is required");
        return this.clientCall(request, CreateConnectionValidationResponse::builder).logger(LOG, "createConnectionValidation").serviceDetails("DataIntegration", "CreateConnectionValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ConnectionValidation/CreateConnectionValidation").method(Method.POST).requestBuilder(CreateConnectionValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connectionValidations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ConnectionValidation.class, CreateConnectionValidationResponse.Builder::connectionValidation).handleResponseHeaderString("etag", CreateConnectionValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateConnectionValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDataAssetResponse> createDataAsset(CreateDataAssetRequest request, AsyncHandler<CreateDataAssetRequest, CreateDataAssetResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataAssetDetails(), "createDataAssetDetails is required");
        return this.clientCall(request, CreateDataAssetResponse::builder).logger(LOG, "createDataAsset").serviceDetails("DataIntegration", "CreateDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataAsset/CreateDataAsset").method(Method.POST).requestBuilder(CreateDataAssetRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataAssets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DataAsset.class, CreateDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", CreateDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDataFlowResponse> createDataFlow(CreateDataFlowRequest request, AsyncHandler<CreateDataFlowRequest, CreateDataFlowResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataFlowDetails(), "createDataFlowDetails is required");
        return this.clientCall(request, CreateDataFlowResponse::builder).logger(LOG, "createDataFlow").serviceDetails("DataIntegration", "CreateDataFlow", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlow/CreateDataFlow").method(Method.POST).requestBuilder(CreateDataFlowRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlows").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DataFlow.class, CreateDataFlowResponse.Builder::dataFlow).handleResponseHeaderString("etag", CreateDataFlowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDataFlowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDataFlowValidationResponse> createDataFlowValidation(CreateDataFlowValidationRequest request, AsyncHandler<CreateDataFlowValidationRequest, CreateDataFlowValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataFlowValidationDetails(), "createDataFlowValidationDetails is required");
        return this.clientCall(request, CreateDataFlowValidationResponse::builder).logger(LOG, "createDataFlowValidation").serviceDetails("DataIntegration", "CreateDataFlowValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlowValidation/CreateDataFlowValidation").method(Method.POST).requestBuilder(CreateDataFlowValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlowValidations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DataFlowValidation.class, CreateDataFlowValidationResponse.Builder::dataFlowValidation).handleResponseHeaderString("etag", CreateDataFlowValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDataFlowValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDisApplicationResponse> createDisApplication(CreateDisApplicationRequest request, AsyncHandler<CreateDisApplicationRequest, CreateDisApplicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDisApplicationDetails(), "createDisApplicationDetails is required");
        return this.clientCall(request, CreateDisApplicationResponse::builder).logger(LOG, "createDisApplication").serviceDetails("DataIntegration", "CreateDisApplication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DisApplication/CreateDisApplication").method(Method.POST).requestBuilder(CreateDisApplicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("disApplications").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DisApplication.class, CreateDisApplicationResponse.Builder::disApplication).handleResponseHeaderString("etag", CreateDisApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDisApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateEntityShapeResponse> createEntityShape(CreateEntityShapeRequest request, AsyncHandler<CreateEntityShapeRequest, CreateEntityShapeResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateEntityShapeDetails(), "createEntityShapeDetails is required");
        return this.clientCall(request, CreateEntityShapeResponse::builder).logger(LOG, "createEntityShape").serviceDetails("DataIntegration", "CreateEntityShape", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataEntity/CreateEntityShape").method(Method.POST).requestBuilder(CreateEntityShapeRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("entityShapes").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(EntityShape.class, CreateEntityShapeResponse.Builder::entityShape).handleResponseHeaderString("opc-request-id", CreateEntityShapeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateExternalPublicationResponse> createExternalPublication(CreateExternalPublicationRequest request, AsyncHandler<CreateExternalPublicationRequest, CreateExternalPublicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateExternalPublicationDetails(), "createExternalPublicationDetails is required");
        return this.clientCall(request, CreateExternalPublicationResponse::builder).logger(LOG, "createExternalPublication").serviceDetails("DataIntegration", "CreateExternalPublication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublication/CreateExternalPublication").method(Method.POST).requestBuilder(CreateExternalPublicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublications").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExternalPublication.class, CreateExternalPublicationResponse.Builder::externalPublication).handleResponseHeaderString("etag", CreateExternalPublicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateExternalPublicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateExternalPublicationValidationResponse> createExternalPublicationValidation(CreateExternalPublicationValidationRequest request, AsyncHandler<CreateExternalPublicationValidationRequest, CreateExternalPublicationValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateExternalPublicationValidationDetails(), "createExternalPublicationValidationDetails is required");
        return this.clientCall(request, CreateExternalPublicationValidationResponse::builder).logger(LOG, "createExternalPublicationValidation").serviceDetails("DataIntegration", "CreateExternalPublicationValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublicationValidation/CreateExternalPublicationValidation").method(Method.POST).requestBuilder(CreateExternalPublicationValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublicationValidations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExternalPublicationValidation.class, CreateExternalPublicationValidationResponse.Builder::externalPublicationValidation).handleResponseHeaderString("etag", CreateExternalPublicationValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateExternalPublicationValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFolderResponse> createFolder(CreateFolderRequest request, AsyncHandler<CreateFolderRequest, CreateFolderResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateFolderDetails(), "createFolderDetails is required");
        return this.clientCall(request, CreateFolderResponse::builder).logger(LOG, "createFolder").serviceDetails("DataIntegration", "CreateFolder", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Folder/CreateFolder").method(Method.POST).requestBuilder(CreateFolderRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("folders").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Folder.class, CreateFolderResponse.Builder::folder).handleResponseHeaderString("etag", CreateFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFolderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFunctionLibraryResponse> createFunctionLibrary(CreateFunctionLibraryRequest request, AsyncHandler<CreateFunctionLibraryRequest, CreateFunctionLibraryResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateFunctionLibraryDetails(), "createFunctionLibraryDetails is required");
        return this.clientCall(request, CreateFunctionLibraryResponse::builder).logger(LOG, "createFunctionLibrary").serviceDetails("DataIntegration", "CreateFunctionLibrary", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/FunctionLibrary/CreateFunctionLibrary").method(Method.POST).requestBuilder(CreateFunctionLibraryRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("functionLibraries").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FunctionLibrary.class, CreateFunctionLibraryResponse.Builder::functionLibrary).handleResponseHeaderString("etag", CreateFunctionLibraryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFunctionLibraryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePatchResponse> createPatch(CreatePatchRequest request, AsyncHandler<CreatePatchRequest, CreatePatchResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePatchDetails(), "createPatchDetails is required");
        return this.clientCall(request, CreatePatchResponse::builder).logger(LOG, "createPatch").serviceDetails("DataIntegration", "CreatePatch", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/CreatePatch").method(Method.POST).requestBuilder(CreatePatchRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("patches").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Patch.class, CreatePatchResponse.Builder::patch).handleResponseHeaderString("etag", CreatePatchResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePatchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePipelineResponse> createPipeline(CreatePipelineRequest request, AsyncHandler<CreatePipelineRequest, CreatePipelineResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePipelineDetails(), "createPipelineDetails is required");
        return this.clientCall(request, CreatePipelineResponse::builder).logger(LOG, "createPipeline").serviceDetails("DataIntegration", "CreatePipeline", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Pipeline/CreatePipeline").method(Method.POST).requestBuilder(CreatePipelineRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelines").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Pipeline.class, CreatePipelineResponse.Builder::pipeline).handleResponseHeaderString("etag", CreatePipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePipelineValidationResponse> createPipelineValidation(CreatePipelineValidationRequest request, AsyncHandler<CreatePipelineValidationRequest, CreatePipelineValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePipelineValidationDetails(), "createPipelineValidationDetails is required");
        return this.clientCall(request, CreatePipelineValidationResponse::builder).logger(LOG, "createPipelineValidation").serviceDetails("DataIntegration", "CreatePipelineValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/PipelineValidation/CreatePipelineValidation").method(Method.POST).requestBuilder(CreatePipelineValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelineValidations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PipelineValidation.class, CreatePipelineValidationResponse.Builder::pipelineValidation).handleResponseHeaderString("etag", CreatePipelineValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePipelineValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("DataIntegration", "CreateProject", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Project/CreateProject").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateScheduleResponse> createSchedule(CreateScheduleRequest request, AsyncHandler<CreateScheduleRequest, CreateScheduleResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateScheduleDetails(), "createScheduleDetails is required");
        return this.clientCall(request, CreateScheduleResponse::builder).logger(LOG, "createSchedule").serviceDetails("DataIntegration", "CreateSchedule", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Schedule/CreateSchedule").method(Method.POST).requestBuilder(CreateScheduleRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("schedules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Schedule.class, CreateScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", CreateScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateScheduleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTaskResponse> createTask(CreateTaskRequest request, AsyncHandler<CreateTaskRequest, CreateTaskResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTaskDetails(), "createTaskDetails is required");
        return this.clientCall(request, CreateTaskResponse::builder).logger(LOG, "createTask").serviceDetails("DataIntegration", "CreateTask", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Task/CreateTask").method(Method.POST).requestBuilder(CreateTaskRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Task.class, CreateTaskResponse.Builder::task).handleResponseHeaderString("etag", CreateTaskResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateTaskRunResponse> createTaskRun(CreateTaskRunRequest request, AsyncHandler<CreateTaskRunRequest, CreateTaskRunResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTaskRunDetails(), "createTaskRunDetails is required");
        return this.clientCall(request, CreateTaskRunResponse::builder).logger(LOG, "createTaskRun").serviceDetails("DataIntegration", "CreateTaskRun", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskRun/CreateTaskRun").method(Method.POST).requestBuilder(CreateTaskRunRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskRuns").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TaskRun.class, CreateTaskRunResponse.Builder::taskRun).handleResponseHeaderString("etag", CreateTaskRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTaskRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateTaskScheduleResponse> createTaskSchedule(CreateTaskScheduleRequest request, AsyncHandler<CreateTaskScheduleRequest, CreateTaskScheduleResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTaskScheduleDetails(), "createTaskScheduleDetails is required");
        return this.clientCall(request, CreateTaskScheduleResponse::builder).logger(LOG, "createTaskSchedule").serviceDetails("DataIntegration", "CreateTaskSchedule", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskSchedule/CreateTaskSchedule").method(Method.POST).requestBuilder(CreateTaskScheduleRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskSchedules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TaskSchedule.class, CreateTaskScheduleResponse.Builder::taskSchedule).handleResponseHeaderString("opc-request-id", CreateTaskScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTaskScheduleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTaskValidationResponse> createTaskValidation(CreateTaskValidationRequest request, AsyncHandler<CreateTaskValidationRequest, CreateTaskValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTaskValidationDetails(), "createTaskValidationDetails is required");
        return this.clientCall(request, CreateTaskValidationResponse::builder).logger(LOG, "createTaskValidation").serviceDetails("DataIntegration", "CreateTaskValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskValidation/CreateTaskValidation").method(Method.POST).requestBuilder(CreateTaskValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("taskValidations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TaskValidation.class, CreateTaskValidationResponse.Builder::taskValidation).handleResponseHeaderString("etag", CreateTaskValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTaskValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateUserDefinedFunctionResponse> createUserDefinedFunction(CreateUserDefinedFunctionRequest request, AsyncHandler<CreateUserDefinedFunctionRequest, CreateUserDefinedFunctionResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateUserDefinedFunctionDetails(), "createUserDefinedFunctionDetails is required");
        return this.clientCall(request, CreateUserDefinedFunctionResponse::builder).logger(LOG, "createUserDefinedFunction").serviceDetails("DataIntegration", "CreateUserDefinedFunction", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunction/CreateUserDefinedFunction").method(Method.POST).requestBuilder(CreateUserDefinedFunctionRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UserDefinedFunction.class, CreateUserDefinedFunctionResponse.Builder::userDefinedFunction).handleResponseHeaderString("etag", CreateUserDefinedFunctionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateUserDefinedFunctionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateUserDefinedFunctionValidationResponse> createUserDefinedFunctionValidation(CreateUserDefinedFunctionValidationRequest request, AsyncHandler<CreateUserDefinedFunctionValidationRequest, CreateUserDefinedFunctionValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateUserDefinedFunctionValidationDetails(), "createUserDefinedFunctionValidationDetails is required");
        return this.clientCall(request, CreateUserDefinedFunctionValidationResponse::builder).logger(LOG, "createUserDefinedFunctionValidation").serviceDetails("DataIntegration", "CreateUserDefinedFunctionValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunctionValidation/CreateUserDefinedFunctionValidation").method(Method.POST).requestBuilder(CreateUserDefinedFunctionValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctionValidations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(UserDefinedFunctionValidation.class, CreateUserDefinedFunctionValidationResponse.Builder::userDefinedFunctionValidation).handleResponseHeaderString("etag", CreateUserDefinedFunctionValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateUserDefinedFunctionValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateWorkspaceResponse> createWorkspace(CreateWorkspaceRequest request, AsyncHandler<CreateWorkspaceRequest, CreateWorkspaceResponse> handler) {
        Objects.requireNonNull(request.getCreateWorkspaceDetails(), "createWorkspaceDetails is required");
        return this.clientCall(request, CreateWorkspaceResponse::builder).logger(LOG, "createWorkspace").serviceDetails("DataIntegration", "CreateWorkspace", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Workspace/CreateWorkspace").method(Method.POST).requestBuilder(CreateWorkspaceRequest::builder).basePath("/20200430").appendPathParam("workspaces").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateWorkspaceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateWorkspaceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request, AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteApplicationResponse::builder).logger(LOG, "deleteApplication").serviceDetails("DataIntegration", "DeleteApplication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/DeleteApplication").method(Method.DELETE).requestBuilder(DeleteApplicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest request, AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("DataIntegration", "DeleteConnection", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Connection/DeleteConnection").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConnectionValidationResponse> deleteConnectionValidation(DeleteConnectionValidationRequest request, AsyncHandler<DeleteConnectionValidationRequest, DeleteConnectionValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionValidationKey(), (String)"connectionValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConnectionValidationResponse::builder).logger(LOG, "deleteConnectionValidation").serviceDetails("DataIntegration", "DeleteConnectionValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ConnectionValidation/DeleteConnectionValidation").method(Method.DELETE).requestBuilder(DeleteConnectionValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connectionValidations").appendPathParam(request.getConnectionValidationKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteConnectionValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDataAssetResponse> deleteDataAsset(DeleteDataAssetRequest request, AsyncHandler<DeleteDataAssetRequest, DeleteDataAssetResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDataAssetResponse::builder).logger(LOG, "deleteDataAsset").serviceDetails("DataIntegration", "DeleteDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataAsset/DeleteDataAsset").method(Method.DELETE).requestBuilder(DeleteDataAssetRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDataFlowResponse> deleteDataFlow(DeleteDataFlowRequest request, AsyncHandler<DeleteDataFlowRequest, DeleteDataFlowResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataFlowKey(), (String)"dataFlowKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDataFlowResponse::builder).logger(LOG, "deleteDataFlow").serviceDetails("DataIntegration", "DeleteDataFlow", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlow/DeleteDataFlow").method(Method.DELETE).requestBuilder(DeleteDataFlowRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlows").appendPathParam(request.getDataFlowKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDataFlowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDataFlowValidationResponse> deleteDataFlowValidation(DeleteDataFlowValidationRequest request, AsyncHandler<DeleteDataFlowValidationRequest, DeleteDataFlowValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataFlowValidationKey(), (String)"dataFlowValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDataFlowValidationResponse::builder).logger(LOG, "deleteDataFlowValidation").serviceDetails("DataIntegration", "DeleteDataFlowValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlowValidation/DeleteDataFlowValidation").method(Method.DELETE).requestBuilder(DeleteDataFlowValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlowValidations").appendPathParam(request.getDataFlowValidationKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDataFlowValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDisApplicationResponse> deleteDisApplication(DeleteDisApplicationRequest request, AsyncHandler<DeleteDisApplicationRequest, DeleteDisApplicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDisApplicationId(), (String)"disApplicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDisApplicationResponse::builder).logger(LOG, "deleteDisApplication").serviceDetails("DataIntegration", "DeleteDisApplication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DisApplication/DeleteDisApplication").method(Method.DELETE).requestBuilder(DeleteDisApplicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("disApplications").appendPathParam(request.getDisApplicationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDisApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteExternalPublicationResponse> deleteExternalPublication(DeleteExternalPublicationRequest request, AsyncHandler<DeleteExternalPublicationRequest, DeleteExternalPublicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExternalPublicationsKey(), (String)"externalPublicationsKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteExternalPublicationResponse::builder).logger(LOG, "deleteExternalPublication").serviceDetails("DataIntegration", "DeleteExternalPublication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublication/DeleteExternalPublication").method(Method.DELETE).requestBuilder(DeleteExternalPublicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublications").appendPathParam(request.getExternalPublicationsKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteExternalPublicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteExternalPublicationValidationResponse> deleteExternalPublicationValidation(DeleteExternalPublicationValidationRequest request, AsyncHandler<DeleteExternalPublicationValidationRequest, DeleteExternalPublicationValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExternalPublicationValidationKey(), (String)"externalPublicationValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteExternalPublicationValidationResponse::builder).logger(LOG, "deleteExternalPublicationValidation").serviceDetails("DataIntegration", "DeleteExternalPublicationValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublicationValidation/DeleteExternalPublicationValidation").method(Method.DELETE).requestBuilder(DeleteExternalPublicationValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublicationValidations").appendPathParam(request.getExternalPublicationValidationKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteExternalPublicationValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFolderResponse> deleteFolder(DeleteFolderRequest request, AsyncHandler<DeleteFolderRequest, DeleteFolderResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFolderResponse::builder).logger(LOG, "deleteFolder").serviceDetails("DataIntegration", "DeleteFolder", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Folder/DeleteFolder").method(Method.DELETE).requestBuilder(DeleteFolderRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("folders").appendPathParam(request.getFolderKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFolderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFunctionLibraryResponse> deleteFunctionLibrary(DeleteFunctionLibraryRequest request, AsyncHandler<DeleteFunctionLibraryRequest, DeleteFunctionLibraryResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFunctionLibraryKey(), (String)"functionLibraryKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFunctionLibraryResponse::builder).logger(LOG, "deleteFunctionLibrary").serviceDetails("DataIntegration", "DeleteFunctionLibrary", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/FunctionLibrary/DeleteFunctionLibrary").method(Method.DELETE).requestBuilder(DeleteFunctionLibraryRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("functionLibraries").appendPathParam(request.getFunctionLibraryKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFunctionLibraryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePatchResponse> deletePatch(DeletePatchRequest request, AsyncHandler<DeletePatchRequest, DeletePatchResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPatchKey(), (String)"patchKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePatchResponse::builder).logger(LOG, "deletePatch").serviceDetails("DataIntegration", "DeletePatch", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/DeletePatch").method(Method.DELETE).requestBuilder(DeletePatchRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("patches").appendPathParam(request.getPatchKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePatchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePipelineResponse> deletePipeline(DeletePipelineRequest request, AsyncHandler<DeletePipelineRequest, DeletePipelineResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPipelineKey(), (String)"pipelineKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePipelineResponse::builder).logger(LOG, "deletePipeline").serviceDetails("DataIntegration", "DeletePipeline", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Pipeline/DeletePipeline").method(Method.DELETE).requestBuilder(DeletePipelineRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelines").appendPathParam(request.getPipelineKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePipelineValidationResponse> deletePipelineValidation(DeletePipelineValidationRequest request, AsyncHandler<DeletePipelineValidationRequest, DeletePipelineValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPipelineValidationKey(), (String)"pipelineValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePipelineValidationResponse::builder).logger(LOG, "deletePipelineValidation").serviceDetails("DataIntegration", "DeletePipelineValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/PipelineValidation/DeletePipelineValidation").method(Method.DELETE).requestBuilder(DeletePipelineValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelineValidations").appendPathParam(request.getPipelineValidationKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePipelineValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProjectKey(), (String)"projectKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("DataIntegration", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("projects").appendPathParam(request.getProjectKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteScheduleResponse> deleteSchedule(DeleteScheduleRequest request, AsyncHandler<DeleteScheduleRequest, DeleteScheduleResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduleKey(), (String)"scheduleKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteScheduleResponse::builder).logger(LOG, "deleteSchedule").serviceDetails("DataIntegration", "DeleteSchedule", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Schedule/DeleteSchedule").method(Method.DELETE).requestBuilder(DeleteScheduleRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("schedules").appendPathParam(request.getScheduleKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTaskResponse> deleteTask(DeleteTaskRequest request, AsyncHandler<DeleteTaskRequest, DeleteTaskResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTaskResponse::builder).logger(LOG, "deleteTask").serviceDetails("DataIntegration", "DeleteTask", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Task/DeleteTask").method(Method.DELETE).requestBuilder(DeleteTaskRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTaskRunResponse> deleteTaskRun(DeleteTaskRunRequest request, AsyncHandler<DeleteTaskRunRequest, DeleteTaskRunResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskRunKey(), (String)"taskRunKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTaskRunResponse::builder).logger(LOG, "deleteTaskRun").serviceDetails("DataIntegration", "DeleteTaskRun", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskRun/DeleteTaskRun").method(Method.DELETE).requestBuilder(DeleteTaskRunRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskRuns").appendPathParam(request.getTaskRunKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTaskRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTaskScheduleResponse> deleteTaskSchedule(DeleteTaskScheduleRequest request, AsyncHandler<DeleteTaskScheduleRequest, DeleteTaskScheduleResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskScheduleKey(), (String)"taskScheduleKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTaskScheduleResponse::builder).logger(LOG, "deleteTaskSchedule").serviceDetails("DataIntegration", "DeleteTaskSchedule", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskSchedule/DeleteTaskSchedule").method(Method.DELETE).requestBuilder(DeleteTaskScheduleRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskSchedules").appendPathParam(request.getTaskScheduleKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTaskScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTaskValidationResponse> deleteTaskValidation(DeleteTaskValidationRequest request, AsyncHandler<DeleteTaskValidationRequest, DeleteTaskValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskValidationKey(), (String)"taskValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTaskValidationResponse::builder).logger(LOG, "deleteTaskValidation").serviceDetails("DataIntegration", "DeleteTaskValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskValidation/DeleteTaskValidation").method(Method.DELETE).requestBuilder(DeleteTaskValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("taskValidations").appendPathParam(request.getTaskValidationKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTaskValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteUserDefinedFunctionResponse> deleteUserDefinedFunction(DeleteUserDefinedFunctionRequest request, AsyncHandler<DeleteUserDefinedFunctionRequest, DeleteUserDefinedFunctionResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserDefinedFunctionKey(), (String)"userDefinedFunctionKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteUserDefinedFunctionResponse::builder).logger(LOG, "deleteUserDefinedFunction").serviceDetails("DataIntegration", "DeleteUserDefinedFunction", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunction/DeleteUserDefinedFunction").method(Method.DELETE).requestBuilder(DeleteUserDefinedFunctionRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctions").appendPathParam(request.getUserDefinedFunctionKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteUserDefinedFunctionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteUserDefinedFunctionValidationResponse> deleteUserDefinedFunctionValidation(DeleteUserDefinedFunctionValidationRequest request, AsyncHandler<DeleteUserDefinedFunctionValidationRequest, DeleteUserDefinedFunctionValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserDefinedFunctionValidationKey(), (String)"userDefinedFunctionValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteUserDefinedFunctionValidationResponse::builder).logger(LOG, "deleteUserDefinedFunctionValidation").serviceDetails("DataIntegration", "DeleteUserDefinedFunctionValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunctionValidation/DeleteUserDefinedFunctionValidation").method(Method.DELETE).requestBuilder(DeleteUserDefinedFunctionValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctionValidations").appendPathParam(request.getUserDefinedFunctionValidationKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteUserDefinedFunctionValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWorkspaceResponse> deleteWorkspace(DeleteWorkspaceRequest request, AsyncHandler<DeleteWorkspaceRequest, DeleteWorkspaceResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWorkspaceResponse::builder).logger(LOG, "deleteWorkspace").serviceDetails("DataIntegration", "DeleteWorkspace", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Workspace/DeleteWorkspace").method(Method.DELETE).requestBuilder(DeleteWorkspaceRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendQueryParam("quiesceTimeout", (Object)request.getQuiesceTimeout()).appendQueryParam("isForceOperation", (Object)request.getIsForceOperation()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteWorkspaceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteWorkspaceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetApplicationResponse> getApplication(GetApplicationRequest request, AsyncHandler<GetApplicationRequest, GetApplicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApplicationResponse::builder).logger(LOG, "getApplication").serviceDetails("DataIntegration", "GetApplication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/GetApplication").method(Method.GET).requestBuilder(GetApplicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Application.class, GetApplicationResponse.Builder::application).handleResponseHeaderString("etag", GetApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConnectionResponse> getConnection(GetConnectionRequest request, AsyncHandler<GetConnectionRequest, GetConnectionResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("DataIntegration", "GetConnection", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Connection/GetConnection").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConnectionValidationResponse> getConnectionValidation(GetConnectionValidationRequest request, AsyncHandler<GetConnectionValidationRequest, GetConnectionValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionValidationKey(), (String)"connectionValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectionValidationResponse::builder).logger(LOG, "getConnectionValidation").serviceDetails("DataIntegration", "GetConnectionValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ConnectionValidation/GetConnectionValidation").method(Method.GET).requestBuilder(GetConnectionValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connectionValidations").appendPathParam(request.getConnectionValidationKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionValidation.class, GetConnectionValidationResponse.Builder::connectionValidation).handleResponseHeaderString("etag", GetConnectionValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCountStatisticResponse> getCountStatistic(GetCountStatisticRequest request, AsyncHandler<GetCountStatisticRequest, GetCountStatisticResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCountStatisticKey(), (String)"countStatisticKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCountStatisticResponse::builder).logger(LOG, "getCountStatistic").serviceDetails("DataIntegration", "GetCountStatistic", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Project/GetCountStatistic").method(Method.GET).requestBuilder(GetCountStatisticRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("countStatistics").appendPathParam(request.getCountStatisticKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CountStatistic.class, GetCountStatisticResponse.Builder::countStatistic).handleResponseHeaderString("opc-request-id", GetCountStatisticResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", GetCountStatisticResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<GetDataAssetResponse> getDataAsset(GetDataAssetRequest request, AsyncHandler<GetDataAssetRequest, GetDataAssetResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDataAssetResponse::builder).logger(LOG, "getDataAsset").serviceDetails("DataIntegration", "GetDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataAsset/GetDataAsset").method(Method.GET).requestBuilder(GetDataAssetRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAsset.class, GetDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", GetDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDataEntityResponse> getDataEntity(GetDataEntityRequest request, AsyncHandler<GetDataEntityRequest, GetDataEntityResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataEntityKey(), (String)"dataEntityKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDataEntityResponse::builder).logger(LOG, "getDataEntity").serviceDetails("DataIntegration", "GetDataEntity", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataEntity/GetDataEntity").method(Method.GET).requestBuilder(GetDataEntityRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("dataEntities").appendPathParam(request.getDataEntityKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataEntity.class, GetDataEntityResponse.Builder::dataEntity).handleResponseHeaderString("opc-request-id", GetDataEntityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDataFlowResponse> getDataFlow(GetDataFlowRequest request, AsyncHandler<GetDataFlowRequest, GetDataFlowResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataFlowKey(), (String)"dataFlowKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDataFlowResponse::builder).logger(LOG, "getDataFlow").serviceDetails("DataIntegration", "GetDataFlow", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlow/GetDataFlow").method(Method.GET).requestBuilder(GetDataFlowRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlows").appendPathParam(request.getDataFlowKey()).appendQueryParam("expandReferences", (Object)request.getExpandReferences()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataFlow.class, GetDataFlowResponse.Builder::dataFlow).handleResponseHeaderString("etag", GetDataFlowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataFlowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDataFlowValidationResponse> getDataFlowValidation(GetDataFlowValidationRequest request, AsyncHandler<GetDataFlowValidationRequest, GetDataFlowValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataFlowValidationKey(), (String)"dataFlowValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDataFlowValidationResponse::builder).logger(LOG, "getDataFlowValidation").serviceDetails("DataIntegration", "GetDataFlowValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlowValidation/GetDataFlowValidation").method(Method.GET).requestBuilder(GetDataFlowValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlowValidations").appendPathParam(request.getDataFlowValidationKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataFlowValidation.class, GetDataFlowValidationResponse.Builder::dataFlowValidation).handleResponseHeaderString("etag", GetDataFlowValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataFlowValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDependentObjectResponse> getDependentObject(GetDependentObjectRequest request, AsyncHandler<GetDependentObjectRequest, GetDependentObjectResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDependentObjectKey(), (String)"dependentObjectKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDependentObjectResponse::builder).logger(LOG, "getDependentObject").serviceDetails("DataIntegration", "GetDependentObject", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/GetDependentObject").method(Method.GET).requestBuilder(GetDependentObjectRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("dependentObjects").appendPathParam(request.getDependentObjectKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DependentObject.class, GetDependentObjectResponse.Builder::dependentObject).handleResponseHeaderString("etag", GetDependentObjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDependentObjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDisApplicationResponse> getDisApplication(GetDisApplicationRequest request, AsyncHandler<GetDisApplicationRequest, GetDisApplicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDisApplicationId(), (String)"disApplicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDisApplicationResponse::builder).logger(LOG, "getDisApplication").serviceDetails("DataIntegration", "GetDisApplication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DisApplication/GetDisApplication").method(Method.GET).requestBuilder(GetDisApplicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("disApplications").appendPathParam(request.getDisApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DisApplication.class, GetDisApplicationResponse.Builder::disApplication).handleResponseHeaderString("etag", GetDisApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDisApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalPublicationResponse> getExternalPublication(GetExternalPublicationRequest request, AsyncHandler<GetExternalPublicationRequest, GetExternalPublicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExternalPublicationsKey(), (String)"externalPublicationsKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalPublicationResponse::builder).logger(LOG, "getExternalPublication").serviceDetails("DataIntegration", "GetExternalPublication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublication/GetExternalPublication").method(Method.GET).requestBuilder(GetExternalPublicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublications").appendPathParam(request.getExternalPublicationsKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalPublication.class, GetExternalPublicationResponse.Builder::externalPublication).handleResponseHeaderString("etag", GetExternalPublicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalPublicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalPublicationValidationResponse> getExternalPublicationValidation(GetExternalPublicationValidationRequest request, AsyncHandler<GetExternalPublicationValidationRequest, GetExternalPublicationValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExternalPublicationValidationKey(), (String)"externalPublicationValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalPublicationValidationResponse::builder).logger(LOG, "getExternalPublicationValidation").serviceDetails("DataIntegration", "GetExternalPublicationValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublicationValidation/GetExternalPublicationValidation").method(Method.GET).requestBuilder(GetExternalPublicationValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublicationValidations").appendPathParam(request.getExternalPublicationValidationKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalPublicationValidation.class, GetExternalPublicationValidationResponse.Builder::externalPublicationValidation).handleResponseHeaderString("etag", GetExternalPublicationValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalPublicationValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFolderResponse> getFolder(GetFolderRequest request, AsyncHandler<GetFolderRequest, GetFolderResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFolderResponse::builder).logger(LOG, "getFolder").serviceDetails("DataIntegration", "GetFolder", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Folder/GetFolder").method(Method.GET).requestBuilder(GetFolderRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("folders").appendPathParam(request.getFolderKey()).appendListQueryParam("projection", request.getProjection(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Folder.class, GetFolderResponse.Builder::folder).handleResponseHeaderString("etag", GetFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFolderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFunctionLibraryResponse> getFunctionLibrary(GetFunctionLibraryRequest request, AsyncHandler<GetFunctionLibraryRequest, GetFunctionLibraryResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFunctionLibraryKey(), (String)"functionLibraryKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFunctionLibraryResponse::builder).logger(LOG, "getFunctionLibrary").serviceDetails("DataIntegration", "GetFunctionLibrary", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/FunctionLibrary/GetFunctionLibrary").method(Method.GET).requestBuilder(GetFunctionLibraryRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("functionLibraries").appendPathParam(request.getFunctionLibraryKey()).appendListQueryParam("projection", request.getProjection(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FunctionLibrary.class, GetFunctionLibraryResponse.Builder::functionLibrary).handleResponseHeaderString("etag", GetFunctionLibraryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFunctionLibraryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPatchResponse> getPatch(GetPatchRequest request, AsyncHandler<GetPatchRequest, GetPatchResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPatchKey(), (String)"patchKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPatchResponse::builder).logger(LOG, "getPatch").serviceDetails("DataIntegration", "GetPatch", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/GetPatch").method(Method.GET).requestBuilder(GetPatchRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("patches").appendPathParam(request.getPatchKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Patch.class, GetPatchResponse.Builder::patch).handleResponseHeaderString("etag", GetPatchResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPatchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPipelineResponse> getPipeline(GetPipelineRequest request, AsyncHandler<GetPipelineRequest, GetPipelineResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPipelineKey(), (String)"pipelineKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPipelineResponse::builder).logger(LOG, "getPipeline").serviceDetails("DataIntegration", "GetPipeline", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Pipeline/GetPipeline").method(Method.GET).requestBuilder(GetPipelineRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelines").appendPathParam(request.getPipelineKey()).appendQueryParam("expandReferences", (Object)request.getExpandReferences()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Pipeline.class, GetPipelineResponse.Builder::pipeline).handleResponseHeaderString("etag", GetPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPipelineValidationResponse> getPipelineValidation(GetPipelineValidationRequest request, AsyncHandler<GetPipelineValidationRequest, GetPipelineValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPipelineValidationKey(), (String)"pipelineValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPipelineValidationResponse::builder).logger(LOG, "getPipelineValidation").serviceDetails("DataIntegration", "GetPipelineValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/PipelineValidation/GetPipelineValidation").method(Method.GET).requestBuilder(GetPipelineValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelineValidations").appendPathParam(request.getPipelineValidationKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PipelineValidation.class, GetPipelineValidationResponse.Builder::pipelineValidation).handleResponseHeaderString("etag", GetPipelineValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPipelineValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProjectKey(), (String)"projectKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("DataIntegration", "GetProject", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("projects").appendPathParam(request.getProjectKey()).appendListQueryParam("projection", request.getProjection(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPublishedObjectResponse> getPublishedObject(GetPublishedObjectRequest request, AsyncHandler<GetPublishedObjectRequest, GetPublishedObjectResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPublishedObjectKey(), (String)"publishedObjectKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPublishedObjectResponse::builder).logger(LOG, "getPublishedObject").serviceDetails("DataIntegration", "GetPublishedObject", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/GetPublishedObject").method(Method.GET).requestBuilder(GetPublishedObjectRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("publishedObjects").appendPathParam(request.getPublishedObjectKey()).appendQueryParam("expandReferences", (Object)request.getExpandReferences()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PublishedObject.class, GetPublishedObjectResponse.Builder::publishedObject).handleResponseHeaderString("etag", GetPublishedObjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPublishedObjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetReferenceResponse> getReference(GetReferenceRequest request, AsyncHandler<GetReferenceRequest, GetReferenceResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getReferenceKey(), (String)"referenceKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetReferenceResponse::builder).logger(LOG, "getReference").serviceDetails("DataIntegration", "GetReference", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Reference/GetReference").method(Method.GET).requestBuilder(GetReferenceRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("references").appendPathParam(request.getReferenceKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Reference.class, GetReferenceResponse.Builder::reference).handleResponseHeaderString("etag", GetReferenceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetReferenceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRuntimeOperatorResponse> getRuntimeOperator(GetRuntimeOperatorRequest request, AsyncHandler<GetRuntimeOperatorRequest, GetRuntimeOperatorResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuntimePipelineKey(), (String)"runtimePipelineKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuntimeOperatorKey(), (String)"runtimeOperatorKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRuntimeOperatorResponse::builder).logger(LOG, "getRuntimeOperator").serviceDetails("DataIntegration", "GetRuntimeOperator", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/RuntimeOperator/GetRuntimeOperator").method(Method.GET).requestBuilder(GetRuntimeOperatorRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("runtimePipelines").appendPathParam(request.getRuntimePipelineKey()).appendPathParam("runtimeOperators").appendPathParam(request.getRuntimeOperatorKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RuntimeOperator.class, GetRuntimeOperatorResponse.Builder::runtimeOperator).handleResponseHeaderString("etag", GetRuntimeOperatorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRuntimeOperatorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRuntimePipelineResponse> getRuntimePipeline(GetRuntimePipelineRequest request, AsyncHandler<GetRuntimePipelineRequest, GetRuntimePipelineResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuntimePipelineKey(), (String)"runtimePipelineKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRuntimePipelineResponse::builder).logger(LOG, "getRuntimePipeline").serviceDetails("DataIntegration", "GetRuntimePipeline", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/RuntimePipeline/GetRuntimePipeline").method(Method.GET).requestBuilder(GetRuntimePipelineRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("runtimePipelines").appendPathParam(request.getRuntimePipelineKey()).appendQueryParam("expandReferences", (Object)request.getExpandReferences()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RuntimePipeline.class, GetRuntimePipelineResponse.Builder::runtimePipeline).handleResponseHeaderString("etag", GetRuntimePipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRuntimePipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetScheduleResponse> getSchedule(GetScheduleRequest request, AsyncHandler<GetScheduleRequest, GetScheduleResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduleKey(), (String)"scheduleKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetScheduleResponse::builder).logger(LOG, "getSchedule").serviceDetails("DataIntegration", "GetSchedule", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Schedule/GetSchedule").method(Method.GET).requestBuilder(GetScheduleRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("schedules").appendPathParam(request.getScheduleKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Schedule.class, GetScheduleResponse.Builder::schedule).handleResponseHeaderString("etag", GetScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSchemaResponse> getSchema(GetSchemaRequest request, AsyncHandler<GetSchemaRequest, GetSchemaResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSchemaResponse::builder).logger(LOG, "getSchema").serviceDetails("DataIntegration", "GetSchema", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Schema/GetSchema").method(Method.GET).requestBuilder(GetSchemaRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Schema.class, GetSchemaResponse.Builder::schema).handleResponseHeaderString("opc-request-id", GetSchemaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTaskResponse> getTask(GetTaskRequest request, AsyncHandler<GetTaskRequest, GetTaskResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTaskResponse::builder).logger(LOG, "getTask").serviceDetails("DataIntegration", "GetTask", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Task/GetTask").method(Method.GET).requestBuilder(GetTaskRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendQueryParam("expandReferences", (Object)request.getExpandReferences()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Task.class, GetTaskResponse.Builder::task).handleResponseHeaderString("etag", GetTaskResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTaskRunResponse> getTaskRun(GetTaskRunRequest request, AsyncHandler<GetTaskRunRequest, GetTaskRunResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskRunKey(), (String)"taskRunKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTaskRunResponse::builder).logger(LOG, "getTaskRun").serviceDetails("DataIntegration", "GetTaskRun", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskRun/GetTaskRun").method(Method.GET).requestBuilder(GetTaskRunRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskRuns").appendPathParam(request.getTaskRunKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskRun.class, GetTaskRunResponse.Builder::taskRun).handleResponseHeaderString("etag", GetTaskRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTaskRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTaskScheduleResponse> getTaskSchedule(GetTaskScheduleRequest request, AsyncHandler<GetTaskScheduleRequest, GetTaskScheduleResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskScheduleKey(), (String)"taskScheduleKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTaskScheduleResponse::builder).logger(LOG, "getTaskSchedule").serviceDetails("DataIntegration", "GetTaskSchedule", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskSchedule/GetTaskSchedule").method(Method.GET).requestBuilder(GetTaskScheduleRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskSchedules").appendPathParam(request.getTaskScheduleKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskSchedule.class, GetTaskScheduleResponse.Builder::taskSchedule).handleResponseHeaderString("etag", GetTaskScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTaskScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTaskValidationResponse> getTaskValidation(GetTaskValidationRequest request, AsyncHandler<GetTaskValidationRequest, GetTaskValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskValidationKey(), (String)"taskValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTaskValidationResponse::builder).logger(LOG, "getTaskValidation").serviceDetails("DataIntegration", "GetTaskValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskValidation/GetTaskValidation").method(Method.GET).requestBuilder(GetTaskValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("taskValidations").appendPathParam(request.getTaskValidationKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskValidation.class, GetTaskValidationResponse.Builder::taskValidation).handleResponseHeaderString("etag", GetTaskValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTaskValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetUserDefinedFunctionResponse> getUserDefinedFunction(GetUserDefinedFunctionRequest request, AsyncHandler<GetUserDefinedFunctionRequest, GetUserDefinedFunctionResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserDefinedFunctionKey(), (String)"userDefinedFunctionKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUserDefinedFunctionResponse::builder).logger(LOG, "getUserDefinedFunction").serviceDetails("DataIntegration", "GetUserDefinedFunction", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunction/GetUserDefinedFunction").method(Method.GET).requestBuilder(GetUserDefinedFunctionRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctions").appendPathParam(request.getUserDefinedFunctionKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UserDefinedFunction.class, GetUserDefinedFunctionResponse.Builder::userDefinedFunction).handleResponseHeaderString("etag", GetUserDefinedFunctionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetUserDefinedFunctionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetUserDefinedFunctionValidationResponse> getUserDefinedFunctionValidation(GetUserDefinedFunctionValidationRequest request, AsyncHandler<GetUserDefinedFunctionValidationRequest, GetUserDefinedFunctionValidationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserDefinedFunctionValidationKey(), (String)"userDefinedFunctionValidationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUserDefinedFunctionValidationResponse::builder).logger(LOG, "getUserDefinedFunctionValidation").serviceDetails("DataIntegration", "GetUserDefinedFunctionValidation", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunctionValidation/GetUserDefinedFunctionValidation").method(Method.GET).requestBuilder(GetUserDefinedFunctionValidationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctionValidations").appendPathParam(request.getUserDefinedFunctionValidationKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UserDefinedFunctionValidation.class, GetUserDefinedFunctionValidationResponse.Builder::userDefinedFunctionValidation).handleResponseHeaderString("etag", GetUserDefinedFunctionValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetUserDefinedFunctionValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DataIntegration", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200430").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<GetWorkspaceResponse> getWorkspace(GetWorkspaceRequest request, AsyncHandler<GetWorkspaceRequest, GetWorkspaceResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkspaceResponse::builder).logger(LOG, "getWorkspace").serviceDetails("DataIntegration", "GetWorkspace", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Workspace/GetWorkspace").method(Method.GET).requestBuilder(GetWorkspaceRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Workspace.class, GetWorkspaceResponse.Builder::workspace).handleResponseHeaderString("etag", GetWorkspaceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkspaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListApplicationsResponse> listApplications(ListApplicationsRequest request, AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListApplicationsResponse::builder).logger(LOG, "listApplications").serviceDetails("DataIntegration", "ListApplications", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/ListApplications").method(Method.GET).requestBuilder(ListApplicationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApplicationSummaryCollection.class, ListApplicationsResponse.Builder::applicationSummaryCollection).handleResponseHeaderString("opc-request-id", ListApplicationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApplicationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListApplicationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListApplicationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListConnectionValidationsResponse> listConnectionValidations(ListConnectionValidationsRequest request, AsyncHandler<ListConnectionValidationsRequest, ListConnectionValidationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListConnectionValidationsResponse::builder).logger(LOG, "listConnectionValidations").serviceDetails("DataIntegration", "ListConnectionValidations", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ConnectionValidation/ListConnectionValidations").method(Method.GET).requestBuilder(ListConnectionValidationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connectionValidations").appendQueryParam("key", (Object)request.getKey()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("identifier", (Object)request.getIdentifier()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionValidationSummaryCollection.class, ListConnectionValidationsResponse.Builder::connectionValidationSummaryCollection).handleResponseHeaderString("opc-request-id", ListConnectionValidationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionValidationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListConnectionValidationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListConnectionValidationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListConnectionsResponse> listConnections(ListConnectionsRequest request, AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDataAssetKey(), "dataAssetKey is required");
        return this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("DataIntegration", "ListConnections", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Connection/ListConnections").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendQueryParam("dataAssetKey", (Object)request.getDataAssetKey()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("type", (Object)request.getType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionSummaryCollection.class, ListConnectionsResponse.Builder::connectionSummaryCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListConnectionsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListConnectionsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDataAssetsResponse> listDataAssets(ListDataAssetsRequest request, AsyncHandler<ListDataAssetsRequest, ListDataAssetsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataAssetsResponse::builder).logger(LOG, "listDataAssets").serviceDetails("DataIntegration", "ListDataAssets", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataAsset/ListDataAssets").method(Method.GET).requestBuilder(ListDataAssetsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataAssets").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("type", (Object)request.getType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAssetSummaryCollection.class, ListDataAssetsResponse.Builder::dataAssetSummaryCollection).handleResponseHeaderString("opc-request-id", ListDataAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataAssetsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDataAssetsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListDataAssetsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDataEntitiesResponse> listDataEntities(ListDataEntitiesRequest request, AsyncHandler<ListDataEntitiesRequest, ListDataEntitiesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataEntitiesResponse::builder).logger(LOG, "listDataEntities").serviceDetails("DataIntegration", "ListDataEntities", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataEntity/ListDataEntities").method(Method.GET).requestBuilder(ListDataEntitiesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("dataEntities").appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("type", (Object)request.getType()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendListQueryParam("nameList", request.getNameList(), CollectionFormatType.Multi).appendQueryParam("isPattern", (Object)request.getIsPattern()).appendListQueryParam("includeTypes", request.getIncludeTypes(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataEntitySummaryCollection.class, ListDataEntitiesResponse.Builder::dataEntitySummaryCollection).handleResponseHeaderString("opc-request-id", ListDataEntitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataEntitiesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDataEntitiesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListDataEntitiesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDataFlowValidationsResponse> listDataFlowValidations(ListDataFlowValidationsRequest request, AsyncHandler<ListDataFlowValidationsRequest, ListDataFlowValidationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataFlowValidationsResponse::builder).logger(LOG, "listDataFlowValidations").serviceDetails("DataIntegration", "ListDataFlowValidations", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlowValidation/ListDataFlowValidations").method(Method.GET).requestBuilder(ListDataFlowValidationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlowValidations").appendQueryParam("key", (Object)request.getKey()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("identifier", (Object)request.getIdentifier()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataFlowValidationSummaryCollection.class, ListDataFlowValidationsResponse.Builder::dataFlowValidationSummaryCollection).handleResponseHeaderString("opc-request-id", ListDataFlowValidationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataFlowValidationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDataFlowValidationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListDataFlowValidationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDataFlowsResponse> listDataFlows(ListDataFlowsRequest request, AsyncHandler<ListDataFlowsRequest, ListDataFlowsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataFlowsResponse::builder).logger(LOG, "listDataFlows").serviceDetails("DataIntegration", "ListDataFlows", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlow/ListDataFlows").method(Method.GET).requestBuilder(ListDataFlowsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlows").appendQueryParam("folderId", (Object)request.getFolderId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataFlowSummaryCollection.class, ListDataFlowsResponse.Builder::dataFlowSummaryCollection).handleResponseHeaderString("opc-request-id", ListDataFlowsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataFlowsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDataFlowsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListDataFlowsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDependentObjectsResponse> listDependentObjects(ListDependentObjectsRequest request, AsyncHandler<ListDependentObjectsRequest, ListDependentObjectsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDependentObjectsResponse::builder).logger(LOG, "listDependentObjects").serviceDetails("DataIntegration", "ListDependentObjects", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/ListDependentObjects").method(Method.GET).requestBuilder(ListDependentObjectsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("dependentObjects").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendQueryParam("typeInSubtree", (Object)request.getTypeInSubtree()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DependentObjectSummaryCollection.class, ListDependentObjectsResponse.Builder::dependentObjectSummaryCollection).handleResponseHeaderString("opc-request-id", ListDependentObjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDependentObjectsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDependentObjectsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListDependentObjectsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDisApplicationTaskRunLineagesResponse> listDisApplicationTaskRunLineages(ListDisApplicationTaskRunLineagesRequest request, AsyncHandler<ListDisApplicationTaskRunLineagesRequest, ListDisApplicationTaskRunLineagesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDisApplicationId(), (String)"disApplicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDisApplicationTaskRunLineagesResponse::builder).logger(LOG, "listDisApplicationTaskRunLineages").serviceDetails("DataIntegration", "ListDisApplicationTaskRunLineages", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskRunLineageSummaryCollection/ListDisApplicationTaskRunLineages").method(Method.GET).requestBuilder(ListDisApplicationTaskRunLineagesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("disApplications").appendPathParam(request.getDisApplicationId()).appendPathParam("taskRunLineages").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("filter", request.getFilter(), CollectionFormatType.Multi).appendQueryParam("timeUpdatedGreaterThan", (Object)request.getTimeUpdatedGreaterThan()).appendQueryParam("timeUpdatedGreaterThanOrEqualTo", (Object)request.getTimeUpdatedGreaterThanOrEqualTo()).appendQueryParam("timeUpatedLessThan", (Object)request.getTimeUpatedLessThan()).appendQueryParam("timeUpatedLessThanOrEqualTo", (Object)request.getTimeUpatedLessThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskRunLineageSummaryCollection.class, ListDisApplicationTaskRunLineagesResponse.Builder::taskRunLineageSummaryCollection).handleResponseHeaderString("opc-request-id", ListDisApplicationTaskRunLineagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDisApplicationTaskRunLineagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDisApplicationsResponse> listDisApplications(ListDisApplicationsRequest request, AsyncHandler<ListDisApplicationsRequest, ListDisApplicationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDisApplicationsResponse::builder).logger(LOG, "listDisApplications").serviceDetails("DataIntegration", "ListDisApplications", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DisApplication/ListDisApplications").method(Method.GET).requestBuilder(ListDisApplicationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("disApplications").appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DisApplicationSummaryCollection.class, ListDisApplicationsResponse.Builder::disApplicationSummaryCollection).handleResponseHeaderString("opc-request-id", ListDisApplicationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDisApplicationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDisApplicationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListDisApplicationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListExternalPublicationValidationsResponse> listExternalPublicationValidations(ListExternalPublicationValidationsRequest request, AsyncHandler<ListExternalPublicationValidationsRequest, ListExternalPublicationValidationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListExternalPublicationValidationsResponse::builder).logger(LOG, "listExternalPublicationValidations").serviceDetails("DataIntegration", "ListExternalPublicationValidations", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublicationValidation/ListExternalPublicationValidations").method(Method.GET).requestBuilder(ListExternalPublicationValidationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublicationValidations").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalPublicationValidationSummaryCollection.class, ListExternalPublicationValidationsResponse.Builder::externalPublicationValidationSummaryCollection).handleResponseHeaderString("opc-request-id", ListExternalPublicationValidationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalPublicationValidationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListExternalPublicationValidationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListExternalPublicationValidationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListExternalPublicationsResponse> listExternalPublications(ListExternalPublicationsRequest request, AsyncHandler<ListExternalPublicationsRequest, ListExternalPublicationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListExternalPublicationsResponse::builder).logger(LOG, "listExternalPublications").serviceDetails("DataIntegration", "ListExternalPublications", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublication/ListExternalPublications").method(Method.GET).requestBuilder(ListExternalPublicationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublications").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalPublicationSummaryCollection.class, ListExternalPublicationsResponse.Builder::externalPublicationSummaryCollection).handleResponseHeaderString("opc-request-id", ListExternalPublicationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalPublicationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListExternalPublicationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListExternalPublicationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListFoldersResponse> listFolders(ListFoldersRequest request, AsyncHandler<ListFoldersRequest, ListFoldersResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFoldersResponse::builder).logger(LOG, "listFolders").serviceDetails("DataIntegration", "ListFolders", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Folder/ListFolders").method(Method.GET).requestBuilder(ListFoldersRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("folders").appendQueryParam("aggregatorKey", (Object)request.getAggregatorKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FolderSummaryCollection.class, ListFoldersResponse.Builder::folderSummaryCollection).handleResponseHeaderString("opc-request-id", ListFoldersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFoldersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListFoldersResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListFoldersResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListFunctionLibrariesResponse> listFunctionLibraries(ListFunctionLibrariesRequest request, AsyncHandler<ListFunctionLibrariesRequest, ListFunctionLibrariesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFunctionLibrariesResponse::builder).logger(LOG, "listFunctionLibraries").serviceDetails("DataIntegration", "ListFunctionLibraries", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/FunctionLibrary/ListFunctionLibraries").method(Method.GET).requestBuilder(ListFunctionLibrariesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("functionLibraries").appendQueryParam("aggregatorKey", (Object)request.getAggregatorKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FunctionLibrarySummaryCollection.class, ListFunctionLibrariesResponse.Builder::functionLibrarySummaryCollection).handleResponseHeaderString("opc-request-id", ListFunctionLibrariesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFunctionLibrariesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListFunctionLibrariesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListFunctionLibrariesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListPatchChangesResponse> listPatchChanges(ListPatchChangesRequest request, AsyncHandler<ListPatchChangesRequest, ListPatchChangesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPatchChangesResponse::builder).logger(LOG, "listPatchChanges").serviceDetails("DataIntegration", "ListPatchChanges", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/ListPatchChanges").method(Method.GET).requestBuilder(ListPatchChangesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("patchChanges").appendQueryParam("name", (Object)request.getName()).appendQueryParam("sincePatch", (Object)request.getSincePatch()).appendQueryParam("toPatch", (Object)request.getToPatch()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PatchChangeSummaryCollection.class, ListPatchChangesResponse.Builder::patchChangeSummaryCollection).handleResponseHeaderString("opc-request-id", ListPatchChangesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPatchChangesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListPatchChangesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListPatchChangesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListPatchesResponse> listPatches(ListPatchesRequest request, AsyncHandler<ListPatchesRequest, ListPatchesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPatchesResponse::builder).logger(LOG, "listPatches").serviceDetails("DataIntegration", "ListPatches", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/ListPatches").method(Method.GET).requestBuilder(ListPatchesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("patches").appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PatchSummaryCollection.class, ListPatchesResponse.Builder::patchSummaryCollection).handleResponseHeaderString("opc-request-id", ListPatchesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPatchesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListPatchesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListPatchesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListPipelineValidationsResponse> listPipelineValidations(ListPipelineValidationsRequest request, AsyncHandler<ListPipelineValidationsRequest, ListPipelineValidationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPipelineValidationsResponse::builder).logger(LOG, "listPipelineValidations").serviceDetails("DataIntegration", "ListPipelineValidations", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/PipelineValidation/ListPipelineValidations").method(Method.GET).requestBuilder(ListPipelineValidationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelineValidations").appendQueryParam("key", (Object)request.getKey()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("identifier", (Object)request.getIdentifier()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PipelineValidationSummaryCollection.class, ListPipelineValidationsResponse.Builder::pipelineValidationSummaryCollection).handleResponseHeaderString("opc-request-id", ListPipelineValidationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPipelineValidationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListPipelineValidationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListPipelineValidationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListPipelinesResponse> listPipelines(ListPipelinesRequest request, AsyncHandler<ListPipelinesRequest, ListPipelinesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPipelinesResponse::builder).logger(LOG, "listPipelines").serviceDetails("DataIntegration", "ListPipelines", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Pipeline/ListPipelines").method(Method.GET).requestBuilder(ListPipelinesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelines").appendQueryParam("aggregatorKey", (Object)request.getAggregatorKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PipelineSummaryCollection.class, ListPipelinesResponse.Builder::pipelineSummaryCollection).handleResponseHeaderString("opc-request-id", ListPipelinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPipelinesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListPipelinesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListPipelinesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("DataIntegration", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Project/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("projects").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProjectSummaryCollection.class, ListProjectsResponse.Builder::projectSummaryCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListProjectsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListProjectsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListPublishedObjectsResponse> listPublishedObjects(ListPublishedObjectsRequest request, AsyncHandler<ListPublishedObjectsRequest, ListPublishedObjectsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPublishedObjectsResponse::builder).logger(LOG, "listPublishedObjects").serviceDetails("DataIntegration", "ListPublishedObjects", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/ListPublishedObjects").method(Method.GET).requestBuilder(ListPublishedObjectsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("publishedObjects").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameStartsWith", (Object)request.getNameStartsWith()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendQueryParam("typeInSubtree", (Object)request.getTypeInSubtree()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PublishedObjectSummaryCollection.class, ListPublishedObjectsResponse.Builder::publishedObjectSummaryCollection).handleResponseHeaderString("opc-request-id", ListPublishedObjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPublishedObjectsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListPublishedObjectsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListPublishedObjectsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListReferencesResponse> listReferences(ListReferencesRequest request, AsyncHandler<ListReferencesRequest, ListReferencesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListReferencesResponse::builder).logger(LOG, "listReferences").serviceDetails("DataIntegration", "ListReferences", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Reference/ListReferences").method(Method.GET).requestBuilder(ListReferencesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("references").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReferenceSummaryCollection.class, ListReferencesResponse.Builder::referenceSummaryCollection).handleResponseHeaderString("etag", ListReferencesResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ListReferencesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListReferencesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListReferencesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListReferencesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListRuntimeOperatorsResponse> listRuntimeOperators(ListRuntimeOperatorsRequest request, AsyncHandler<ListRuntimeOperatorsRequest, ListRuntimeOperatorsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuntimePipelineKey(), (String)"runtimePipelineKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRuntimeOperatorsResponse::builder).logger(LOG, "listRuntimeOperators").serviceDetails("DataIntegration", "ListRuntimeOperators", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/RuntimeOperatorSummaryCollection/ListRuntimeOperators").method(Method.GET).requestBuilder(ListRuntimeOperatorsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("runtimePipelines").appendPathParam(request.getRuntimePipelineKey()).appendPathParam("runtimeOperators").appendListQueryParam("key", request.getKey(), CollectionFormatType.Multi).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("aggregatorType", request.getAggregatorType(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RuntimeOperatorSummaryCollection.class, ListRuntimeOperatorsResponse.Builder::runtimeOperatorSummaryCollection).handleResponseHeaderString("opc-request-id", ListRuntimeOperatorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRuntimeOperatorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRuntimePipelinesResponse> listRuntimePipelines(ListRuntimePipelinesRequest request, AsyncHandler<ListRuntimePipelinesRequest, ListRuntimePipelinesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRuntimePipelinesResponse::builder).logger(LOG, "listRuntimePipelines").serviceDetails("DataIntegration", "ListRuntimePipelines", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/RuntimePipelineSummaryCollection/ListRuntimePipelines").method(Method.GET).requestBuilder(ListRuntimePipelinesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("runtimePipelines").appendListQueryParam("key", request.getKey(), CollectionFormatType.Multi).appendQueryParam("aggregatorKey", (Object)request.getAggregatorKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("aggregatorType", request.getAggregatorType(), CollectionFormatType.Multi).appendListQueryParam("filter", request.getFilter(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RuntimePipelineSummaryCollection.class, ListRuntimePipelinesResponse.Builder::runtimePipelineSummaryCollection).handleResponseHeaderString("opc-request-id", ListRuntimePipelinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRuntimePipelinesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSchedulesResponse> listSchedules(ListSchedulesRequest request, AsyncHandler<ListSchedulesRequest, ListSchedulesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSchedulesResponse::builder).logger(LOG, "listSchedules").serviceDetails("DataIntegration", "ListSchedules", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Schedule/ListSchedules").method(Method.GET).requestBuilder(ListSchedulesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("schedules").appendListQueryParam("key", request.getKey(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduleSummaryCollection.class, ListSchedulesResponse.Builder::scheduleSummaryCollection).handleResponseHeaderString("opc-request-id", ListSchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSchedulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSchedulesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListSchedulesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListSchemasResponse> listSchemas(ListSchemasRequest request, AsyncHandler<ListSchemasRequest, ListSchemasResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSchemaResourceName(), "schemaResourceName is required");
        return this.clientCall(request, ListSchemasResponse::builder).logger(LOG, "listSchemas").serviceDetails("DataIntegration", "ListSchemas", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Schema/ListSchemas").method(Method.GET).requestBuilder(ListSchemasRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("schemaResourceName", (Object)request.getSchemaResourceName()).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("nameList", request.getNameList(), CollectionFormatType.Multi).appendListQueryParam("includeTypes", request.getIncludeTypes(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SchemaSummaryCollection.class, ListSchemasResponse.Builder::schemaSummaryCollection).handleResponseHeaderString("opc-request-id", ListSchemasResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSchemasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSchemasResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListSchemasResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListTaskRunLineagesResponse> listTaskRunLineages(ListTaskRunLineagesRequest request, AsyncHandler<ListTaskRunLineagesRequest, ListTaskRunLineagesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTaskRunLineagesResponse::builder).logger(LOG, "listTaskRunLineages").serviceDetails("DataIntegration", "ListTaskRunLineages", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskRunLineageSummaryCollection/ListTaskRunLineages").method(Method.GET).requestBuilder(ListTaskRunLineagesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskRunLineages").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("filter", request.getFilter(), CollectionFormatType.Multi).appendQueryParam("timeUpdatedGreaterThan", (Object)request.getTimeUpdatedGreaterThan()).appendQueryParam("timeUpdatedGreaterThanOrEqualTo", (Object)request.getTimeUpdatedGreaterThanOrEqualTo()).appendQueryParam("timeUpatedLessThan", (Object)request.getTimeUpatedLessThan()).appendQueryParam("timeUpatedLessThanOrEqualTo", (Object)request.getTimeUpatedLessThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskRunLineageSummaryCollection.class, ListTaskRunLineagesResponse.Builder::taskRunLineageSummaryCollection).handleResponseHeaderString("opc-request-id", ListTaskRunLineagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTaskRunLineagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTaskRunLogsResponse> listTaskRunLogs(ListTaskRunLogsRequest request, AsyncHandler<ListTaskRunLogsRequest, ListTaskRunLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskRunKey(), (String)"taskRunKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTaskRunLogsResponse::builder).logger(LOG, "listTaskRunLogs").serviceDetails("DataIntegration", "ListTaskRunLogs", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskRunLogSummary/ListTaskRunLogs").method(Method.GET).requestBuilder(ListTaskRunLogsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskRuns").appendPathParam(request.getTaskRunKey()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(TaskRunLogSummary.class, ListTaskRunLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTaskRunLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTaskRunLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListTaskRunLogsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListTaskRunLogsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListTaskRunsResponse> listTaskRuns(ListTaskRunsRequest request, AsyncHandler<ListTaskRunsRequest, ListTaskRunsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTaskRunsResponse::builder).logger(LOG, "listTaskRuns").serviceDetails("DataIntegration", "ListTaskRuns", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskRun/ListTaskRuns").method(Method.GET).requestBuilder(ListTaskRunsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskRuns").appendListQueryParam("key", request.getKey(), CollectionFormatType.Multi).appendQueryParam("aggregatorKey", (Object)request.getAggregatorKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("filter", request.getFilter(), CollectionFormatType.Multi).appendQueryParam("nameStartsWith", (Object)request.getNameStartsWith()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskRunSummaryCollection.class, ListTaskRunsResponse.Builder::taskRunSummaryCollection).handleResponseHeaderString("opc-request-id", ListTaskRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTaskRunsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListTaskRunsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListTaskRunsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListTaskSchedulesResponse> listTaskSchedules(ListTaskSchedulesRequest request, AsyncHandler<ListTaskSchedulesRequest, ListTaskSchedulesResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTaskSchedulesResponse::builder).logger(LOG, "listTaskSchedules").serviceDetails("DataIntegration", "ListTaskSchedules", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskSchedule/ListTaskSchedules").method(Method.GET).requestBuilder(ListTaskSchedulesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskSchedules").appendListQueryParam("key", request.getKey(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("isEnabled", (Object)request.getIsEnabled()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskScheduleSummaryCollection.class, ListTaskSchedulesResponse.Builder::taskScheduleSummaryCollection).handleResponseHeaderString("opc-request-id", ListTaskSchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTaskSchedulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListTaskSchedulesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListTaskSchedulesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListTaskValidationsResponse> listTaskValidations(ListTaskValidationsRequest request, AsyncHandler<ListTaskValidationsRequest, ListTaskValidationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTaskValidationsResponse::builder).logger(LOG, "listTaskValidations").serviceDetails("DataIntegration", "ListTaskValidations", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskValidation/ListTaskValidations").method(Method.GET).requestBuilder(ListTaskValidationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("taskValidations").appendQueryParam("key", (Object)request.getKey()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("identifier", (Object)request.getIdentifier()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskValidationSummaryCollection.class, ListTaskValidationsResponse.Builder::taskValidationSummaryCollection).handleResponseHeaderString("opc-request-id", ListTaskValidationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTaskValidationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListTaskValidationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListTaskValidationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListTasksResponse> listTasks(ListTasksRequest request, AsyncHandler<ListTasksRequest, ListTasksResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTasksResponse::builder).logger(LOG, "listTasks").serviceDetails("DataIntegration", "ListTasks", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Task/ListTasks").method(Method.GET).requestBuilder(ListTasksRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendQueryParam("folderId", (Object)request.getFolderId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("key", request.getKey(), CollectionFormatType.Multi).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskSummaryCollection.class, ListTasksResponse.Builder::taskSummaryCollection).handleResponseHeaderString("opc-request-id", ListTasksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTasksResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListTasksResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListTasksResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListUserDefinedFunctionValidationsResponse> listUserDefinedFunctionValidations(ListUserDefinedFunctionValidationsRequest request, AsyncHandler<ListUserDefinedFunctionValidationsRequest, ListUserDefinedFunctionValidationsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListUserDefinedFunctionValidationsResponse::builder).logger(LOG, "listUserDefinedFunctionValidations").serviceDetails("DataIntegration", "ListUserDefinedFunctionValidations", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunctionValidation/ListUserDefinedFunctionValidations").method(Method.GET).requestBuilder(ListUserDefinedFunctionValidationsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctionValidations").appendQueryParam("key", (Object)request.getKey()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("identifier", (Object)request.getIdentifier()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UserDefinedFunctionValidationSummaryCollection.class, ListUserDefinedFunctionValidationsResponse.Builder::userDefinedFunctionValidationSummaryCollection).handleResponseHeaderString("opc-request-id", ListUserDefinedFunctionValidationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUserDefinedFunctionValidationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListUserDefinedFunctionValidationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListUserDefinedFunctionValidationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListUserDefinedFunctionsResponse> listUserDefinedFunctions(ListUserDefinedFunctionsRequest request, AsyncHandler<ListUserDefinedFunctionsRequest, ListUserDefinedFunctionsResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListUserDefinedFunctionsResponse::builder).logger(LOG, "listUserDefinedFunctions").serviceDetails("DataIntegration", "ListUserDefinedFunctions", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunction/ListUserDefinedFunctions").method(Method.GET).requestBuilder(ListUserDefinedFunctionsRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctions").appendQueryParam("functionLibraryKey", (Object)request.getFunctionLibraryKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("identifier", request.getIdentifier(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UserDefinedFunctionSummaryCollection.class, ListUserDefinedFunctionsResponse.Builder::userDefinedFunctionSummaryCollection).handleResponseHeaderString("opc-request-id", ListUserDefinedFunctionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUserDefinedFunctionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListUserDefinedFunctionsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListUserDefinedFunctionsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DataIntegration", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200430").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("workRequestErrors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DataIntegration", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200430").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DataIntegration", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200430").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workspaceId", (Object)request.getWorkspaceId()).appendEnumQueryParam("workRequestStatus", (BmcEnum)request.getWorkRequestStatus()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkspacesResponse> listWorkspaces(ListWorkspacesRequest request, AsyncHandler<ListWorkspacesRequest, ListWorkspacesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkspacesResponse::builder).logger(LOG, "listWorkspaces").serviceDetails("DataIntegration", "ListWorkspaces", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Workspace/ListWorkspaces").method(Method.GET).requestBuilder(ListWorkspacesRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkspaceSummary.class, ListWorkspacesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkspacesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkspacesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<StartWorkspaceResponse> startWorkspace(StartWorkspaceRequest request, AsyncHandler<StartWorkspaceRequest, StartWorkspaceResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartWorkspaceResponse::builder).logger(LOG, "startWorkspace").serviceDetails("DataIntegration", "StartWorkspace", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Workspace/StartWorkspace").method(Method.POST).requestBuilder(StartWorkspaceRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartWorkspaceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartWorkspaceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopWorkspaceResponse> stopWorkspace(StopWorkspaceRequest request, AsyncHandler<StopWorkspaceRequest, StopWorkspaceResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopWorkspaceResponse::builder).logger(LOG, "stopWorkspace").serviceDetails("DataIntegration", "StopWorkspace", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Workspace/StopWorkspace").method(Method.POST).requestBuilder(StopWorkspaceRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("actions").appendPathParam("stop").appendQueryParam("quiesceTimeout", (Object)request.getQuiesceTimeout()).appendQueryParam("isForceOperation", (Object)request.getIsForceOperation()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StopWorkspaceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopWorkspaceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request, AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateApplicationDetails(), "updateApplicationDetails is required");
        return this.clientCall(request, UpdateApplicationResponse::builder).logger(LOG, "updateApplication").serviceDetails("DataIntegration", "UpdateApplication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Application/UpdateApplication").method(Method.PUT).requestBuilder(UpdateApplicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Application.class, UpdateApplicationResponse.Builder::application).handleResponseHeaderString("etag", UpdateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest request, AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("DataIntegration", "UpdateConnection", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Connection/UpdateConnection").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Connection.class, UpdateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", UpdateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDataAssetResponse> updateDataAsset(UpdateDataAssetRequest request, AsyncHandler<UpdateDataAssetRequest, UpdateDataAssetResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDataAssetDetails(), "updateDataAssetDetails is required");
        return this.clientCall(request, UpdateDataAssetResponse::builder).logger(LOG, "updateDataAsset").serviceDetails("DataIntegration", "UpdateDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataAsset/UpdateDataAsset").method(Method.PUT).requestBuilder(UpdateDataAssetRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DataAsset.class, UpdateDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", UpdateDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDataFlowResponse> updateDataFlow(UpdateDataFlowRequest request, AsyncHandler<UpdateDataFlowRequest, UpdateDataFlowResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataFlowKey(), (String)"dataFlowKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDataFlowDetails(), "updateDataFlowDetails is required");
        return this.clientCall(request, UpdateDataFlowResponse::builder).logger(LOG, "updateDataFlow").serviceDetails("DataIntegration", "UpdateDataFlow", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DataFlow/UpdateDataFlow").method(Method.PUT).requestBuilder(UpdateDataFlowRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("dataFlows").appendPathParam(request.getDataFlowKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DataFlow.class, UpdateDataFlowResponse.Builder::dataFlow).handleResponseHeaderString("etag", UpdateDataFlowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDataFlowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDisApplicationResponse> updateDisApplication(UpdateDisApplicationRequest request, AsyncHandler<UpdateDisApplicationRequest, UpdateDisApplicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDisApplicationId(), (String)"disApplicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDisApplicationDetails(), "updateDisApplicationDetails is required");
        return this.clientCall(request, UpdateDisApplicationResponse::builder).logger(LOG, "updateDisApplication").serviceDetails("DataIntegration", "UpdateDisApplication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/DisApplication/UpdateDisApplication").method(Method.PUT).requestBuilder(UpdateDisApplicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("disApplications").appendPathParam(request.getDisApplicationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DisApplication.class, UpdateDisApplicationResponse.Builder::disApplication).handleResponseHeaderString("etag", UpdateDisApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDisApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalPublicationResponse> updateExternalPublication(UpdateExternalPublicationRequest request, AsyncHandler<UpdateExternalPublicationRequest, UpdateExternalPublicationResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExternalPublicationsKey(), (String)"externalPublicationsKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalPublicationDetails(), "updateExternalPublicationDetails is required");
        return this.clientCall(request, UpdateExternalPublicationResponse::builder).logger(LOG, "updateExternalPublication").serviceDetails("DataIntegration", "UpdateExternalPublication", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/ExternalPublication/UpdateExternalPublication").method(Method.PUT).requestBuilder(UpdateExternalPublicationRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).appendPathParam("externalPublications").appendPathParam(request.getExternalPublicationsKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalPublication.class, UpdateExternalPublicationResponse.Builder::externalPublication).handleResponseHeaderString("etag", UpdateExternalPublicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateExternalPublicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFolderResponse> updateFolder(UpdateFolderRequest request, AsyncHandler<UpdateFolderRequest, UpdateFolderResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFolderDetails(), "updateFolderDetails is required");
        return this.clientCall(request, UpdateFolderResponse::builder).logger(LOG, "updateFolder").serviceDetails("DataIntegration", "UpdateFolder", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Folder/UpdateFolder").method(Method.PUT).requestBuilder(UpdateFolderRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("folders").appendPathParam(request.getFolderKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Folder.class, UpdateFolderResponse.Builder::folder).handleResponseHeaderString("etag", UpdateFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateFolderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFunctionLibraryResponse> updateFunctionLibrary(UpdateFunctionLibraryRequest request, AsyncHandler<UpdateFunctionLibraryRequest, UpdateFunctionLibraryResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFunctionLibraryKey(), (String)"functionLibraryKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFunctionLibraryDetails(), "updateFunctionLibraryDetails is required");
        return this.clientCall(request, UpdateFunctionLibraryResponse::builder).logger(LOG, "updateFunctionLibrary").serviceDetails("DataIntegration", "UpdateFunctionLibrary", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/FunctionLibrary/UpdateFunctionLibrary").method(Method.PUT).requestBuilder(UpdateFunctionLibraryRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("functionLibraries").appendPathParam(request.getFunctionLibraryKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(FunctionLibrary.class, UpdateFunctionLibraryResponse.Builder::functionLibrary).handleResponseHeaderString("etag", UpdateFunctionLibraryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateFunctionLibraryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePipelineResponse> updatePipeline(UpdatePipelineRequest request, AsyncHandler<UpdatePipelineRequest, UpdatePipelineResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPipelineKey(), (String)"pipelineKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePipelineDetails(), "updatePipelineDetails is required");
        return this.clientCall(request, UpdatePipelineResponse::builder).logger(LOG, "updatePipeline").serviceDetails("DataIntegration", "UpdatePipeline", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Pipeline/UpdatePipeline").method(Method.PUT).requestBuilder(UpdatePipelineRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("pipelines").appendPathParam(request.getPipelineKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Pipeline.class, UpdatePipelineResponse.Builder::pipeline).handleResponseHeaderString("etag", UpdatePipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePipelineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProjectKey(), (String)"projectKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("DataIntegration", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("projects").appendPathParam(request.getProjectKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Project.class, UpdateProjectResponse.Builder::project).handleResponseHeaderString("etag", UpdateProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateReferenceResponse> updateReference(UpdateReferenceRequest request, AsyncHandler<UpdateReferenceRequest, UpdateReferenceResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getReferenceKey(), (String)"referenceKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateReferenceDetails(), "updateReferenceDetails is required");
        return this.clientCall(request, UpdateReferenceResponse::builder).logger(LOG, "updateReference").serviceDetails("DataIntegration", "UpdateReference", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Reference/UpdateReference").method(Method.PUT).requestBuilder(UpdateReferenceRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("references").appendPathParam(request.getReferenceKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Reference.class, UpdateReferenceResponse.Builder::reference).handleResponseHeaderString("etag", UpdateReferenceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateReferenceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateScheduleResponse> updateSchedule(UpdateScheduleRequest request, AsyncHandler<UpdateScheduleRequest, UpdateScheduleResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduleKey(), (String)"scheduleKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateScheduleDetails(), "updateScheduleDetails is required");
        return this.clientCall(request, UpdateScheduleResponse::builder).logger(LOG, "updateSchedule").serviceDetails("DataIntegration", "UpdateSchedule", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Schedule/UpdateSchedule").method(Method.PUT).requestBuilder(UpdateScheduleRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("schedules").appendPathParam(request.getScheduleKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Schedule.class, UpdateScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", UpdateScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateScheduleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateTaskResponse> updateTask(UpdateTaskRequest request, AsyncHandler<UpdateTaskRequest, UpdateTaskResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskKey(), (String)"taskKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTaskDetails(), "updateTaskDetails is required");
        return this.clientCall(request, UpdateTaskResponse::builder).logger(LOG, "updateTask").serviceDetails("DataIntegration", "UpdateTask", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Task/UpdateTask").method(Method.PUT).requestBuilder(UpdateTaskRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("tasks").appendPathParam(request.getTaskKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Task.class, UpdateTaskResponse.Builder::task).handleResponseHeaderString("etag", UpdateTaskResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateTaskRunResponse> updateTaskRun(UpdateTaskRunRequest request, AsyncHandler<UpdateTaskRunRequest, UpdateTaskRunResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskRunKey(), (String)"taskRunKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTaskRunDetails(), "updateTaskRunDetails is required");
        return this.clientCall(request, UpdateTaskRunResponse::builder).logger(LOG, "updateTaskRun").serviceDetails("DataIntegration", "UpdateTaskRun", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskRun/UpdateTaskRun").method(Method.PUT).requestBuilder(UpdateTaskRunRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskRuns").appendPathParam(request.getTaskRunKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(TaskRunDetails.class, UpdateTaskRunResponse.Builder::taskRunDetails).handleResponseHeaderString("etag", UpdateTaskRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTaskRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateTaskScheduleResponse> updateTaskSchedule(UpdateTaskScheduleRequest request, AsyncHandler<UpdateTaskScheduleRequest, UpdateTaskScheduleResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTaskScheduleKey(), (String)"taskScheduleKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTaskScheduleDetails(), "updateTaskScheduleDetails is required");
        return this.clientCall(request, UpdateTaskScheduleResponse::builder).logger(LOG, "updateTaskSchedule").serviceDetails("DataIntegration", "UpdateTaskSchedule", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/TaskSchedule/UpdateTaskSchedule").method(Method.PUT).requestBuilder(UpdateTaskScheduleRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("applications").appendPathParam(request.getApplicationKey()).appendPathParam("taskSchedules").appendPathParam(request.getTaskScheduleKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TaskSchedule.class, UpdateTaskScheduleResponse.Builder::taskSchedule).handleResponseHeaderString("opc-request-id", UpdateTaskScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTaskScheduleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateUserDefinedFunctionResponse> updateUserDefinedFunction(UpdateUserDefinedFunctionRequest request, AsyncHandler<UpdateUserDefinedFunctionRequest, UpdateUserDefinedFunctionResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserDefinedFunctionKey(), (String)"userDefinedFunctionKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateUserDefinedFunctionDetails(), "updateUserDefinedFunctionDetails is required");
        return this.clientCall(request, UpdateUserDefinedFunctionResponse::builder).logger(LOG, "updateUserDefinedFunction").serviceDetails("DataIntegration", "UpdateUserDefinedFunction", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/UserDefinedFunction/UpdateUserDefinedFunction").method(Method.PUT).requestBuilder(UpdateUserDefinedFunctionRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).appendPathParam("userDefinedFunctions").appendPathParam(request.getUserDefinedFunctionKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(UserDefinedFunction.class, UpdateUserDefinedFunctionResponse.Builder::userDefinedFunction).handleResponseHeaderString("etag", UpdateUserDefinedFunctionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateUserDefinedFunctionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateWorkspaceResponse> updateWorkspace(UpdateWorkspaceRequest request, AsyncHandler<UpdateWorkspaceRequest, UpdateWorkspaceResponse> handler) {
        Validate.notBlank((String)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWorkspaceDetails(), "updateWorkspaceDetails is required");
        return this.clientCall(request, UpdateWorkspaceResponse::builder).logger(LOG, "updateWorkspace").serviceDetails("DataIntegration", "UpdateWorkspace", "https://docs.oracle.com/iaas/api/#/en/data-integration/20200430/Workspace/UpdateWorkspace").method(Method.PUT).requestBuilder(UpdateWorkspaceRequest::builder).basePath("/20200430").appendPathParam("workspaces").appendPathParam(request.getWorkspaceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Workspace.class, UpdateWorkspaceResponse.Builder::workspace).handleResponseHeaderString("etag", UpdateWorkspaceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateWorkspaceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateWorkspaceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public DataIntegrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataIntegrationAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataIntegrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataIntegrationAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataIntegrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataIntegrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataIntegrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataIntegrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataIntegrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataIntegrationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataIntegrationAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataIntegrationAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataIntegrationAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

