/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.responses;

import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetRunLogResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private Long contentLength;
    private String contentType;
    private String contentEncoding;
    private Map<String, String> opcMeta;
    private InputStream inputStream;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Map<String, String> getOpcMeta() {
        return this.opcMeta;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "contentLength", "contentType", "contentEncoding", "opcMeta", "inputStream"})
    private GetRunLogResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, Long contentLength, String contentType, String contentEncoding, Map<String, String> opcMeta, InputStream inputStream) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.opcMeta = opcMeta;
        this.inputStream = inputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",contentLength=").append(String.valueOf(this.contentLength));
        sb.append(",contentType=").append(String.valueOf(this.contentType));
        sb.append(",contentEncoding=").append(String.valueOf(this.contentEncoding));
        sb.append(",opcMeta=").append(String.valueOf(this.opcMeta));
        sb.append(",inputStream=").append(String.valueOf(this.inputStream));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRunLogResponse)) {
            return false;
        }
        GetRunLogResponse other = (GetRunLogResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals(this.contentLength, other.contentLength) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.contentEncoding, other.contentEncoding) && Objects.equals(this.opcMeta, other.opcMeta) && Objects.equals(this.inputStream, other.inputStream);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.contentLength == null ? 43 : this.contentLength.hashCode());
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + (this.contentEncoding == null ? 43 : this.contentEncoding.hashCode());
        result = result * 59 + (this.opcMeta == null ? 43 : this.opcMeta.hashCode());
        result = result * 59 + (this.inputStream == null ? 43 : this.inputStream.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetRunLogResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private Long contentLength;
        private String contentType;
        private String contentEncoding;
        private Map<String, String> opcMeta;
        private InputStream inputStream;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder opcMeta(Map<String, String> opcMeta) {
            this.opcMeta = opcMeta;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder copy(GetRunLogResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.contentLength(o.getContentLength());
            this.contentType(o.getContentType());
            this.contentEncoding(o.getContentEncoding());
            this.opcMeta(o.getOpcMeta());
            this.inputStream(o.getInputStream());
            return this;
        }

        public GetRunLogResponse build() {
            return new GetRunLogResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.contentLength, this.contentType, this.contentEncoding, this.opcMeta, this.inputStream);
        }
    }
}

