/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataflow.model.ChangeRunCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeRunCompartmentRequest
extends BmcRequest<ChangeRunCompartmentDetails> {
    private String runId;
    private ChangeRunCompartmentDetails changeRunCompartmentDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getRunId() {
        return this.runId;
    }

    public ChangeRunCompartmentDetails getChangeRunCompartmentDetails() {
        return this.changeRunCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeRunCompartmentDetails getBody$() {
        return this.changeRunCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().runId(this.runId).changeRunCompartmentDetails(this.changeRunCompartmentDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",runId=").append(String.valueOf(this.runId));
        sb.append(",changeRunCompartmentDetails=").append(String.valueOf((Object)this.changeRunCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeRunCompartmentRequest)) {
            return false;
        }
        ChangeRunCompartmentRequest other = (ChangeRunCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.runId, other.runId) && Objects.equals((Object)this.changeRunCompartmentDetails, (Object)other.changeRunCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.runId == null ? 43 : this.runId.hashCode());
        result = result * 59 + (this.changeRunCompartmentDetails == null ? 43 : this.changeRunCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeRunCompartmentRequest, ChangeRunCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String runId = null;
        private ChangeRunCompartmentDetails changeRunCompartmentDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public Builder changeRunCompartmentDetails(ChangeRunCompartmentDetails changeRunCompartmentDetails) {
            this.changeRunCompartmentDetails = changeRunCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeRunCompartmentRequest o) {
            this.runId(o.getRunId());
            this.changeRunCompartmentDetails(o.getChangeRunCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeRunCompartmentRequest build() {
            ChangeRunCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeRunCompartmentDetails body) {
            this.changeRunCompartmentDetails(body);
            return this;
        }

        public ChangeRunCompartmentRequest buildWithoutInvocationCallback() {
            ChangeRunCompartmentRequest request = new ChangeRunCompartmentRequest();
            request.runId = this.runId;
            request.changeRunCompartmentDetails = this.changeRunCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

