/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.WorkRequestOperation;
import com.oracle.bmc.dataflow.model.WorkRequestResource;
import com.oracle.bmc.dataflow.model.WorkRequestStatus;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="operation")
    private final WorkRequestOperation operation;
    @JsonProperty(value="percentComplete")
    private final Float percentComplete;
    @JsonProperty(value="resources")
    private final List<WorkRequestResource> resources;
    @JsonProperty(value="status")
    private final WorkRequestStatus status;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "id", "operation", "percentComplete", "resources", "status", "timeAccepted", "timeStarted", "timeFinished"})
    public WorkRequestSummary(String compartmentId, String id, WorkRequestOperation operation, Float percentComplete, List<WorkRequestResource> resources, WorkRequestStatus status, Date timeAccepted, Date timeStarted, Date timeFinished) {
        this.compartmentId = compartmentId;
        this.id = id;
        this.operation = operation;
        this.percentComplete = percentComplete;
        this.resources = resources;
        this.status = status;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public WorkRequestOperation getOperation() {
        return this.operation;
    }

    public Float getPercentComplete() {
        return this.percentComplete;
    }

    public List<WorkRequestResource> getResources() {
        return this.resources;
    }

    public WorkRequestStatus getStatus() {
        return this.status;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestSummary(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", operation=").append(String.valueOf((Object)this.operation));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", resources=").append(String.valueOf(this.resources));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestSummary)) {
            return false;
        }
        WorkRequestSummary other = (WorkRequestSummary)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.operation, (Object)other.operation) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals(this.resources, other.resources) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.resources == null ? 43 : this.resources.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="operation")
        private WorkRequestOperation operation;
        @JsonProperty(value="percentComplete")
        private Float percentComplete;
        @JsonProperty(value="resources")
        private List<WorkRequestResource> resources;
        @JsonProperty(value="status")
        private WorkRequestStatus status;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder operation(WorkRequestOperation operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public Builder percentComplete(Float percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder resources(List<WorkRequestResource> resources) {
            this.resources = resources;
            this.__explicitlySet__.add("resources");
            return this;
        }

        public Builder status(WorkRequestStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public WorkRequestSummary build() {
            WorkRequestSummary model = new WorkRequestSummary(this.compartmentId, this.id, this.operation, this.percentComplete, this.resources, this.status, this.timeAccepted, this.timeStarted, this.timeFinished);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestSummary model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("resources")) {
                this.resources(model.getResources());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            return this;
        }
    }
}

