/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestLog
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final Long id;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="workRequestid")
    private final String workRequestid;

    @Deprecated
    @ConstructorProperties(value={"id", "message", "timestamp", "workRequestid"})
    public WorkRequestLog(Long id, String message, Date timestamp, String workRequestid) {
        this.id = id;
        this.message = message;
        this.timestamp = timestamp;
        this.workRequestid = workRequestid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getWorkRequestid() {
        return this.workRequestid;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestLog(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", workRequestid=").append(String.valueOf(this.workRequestid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestLog)) {
            return false;
        }
        WorkRequestLog other = (WorkRequestLog)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.message, other.message) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.workRequestid, other.workRequestid) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.workRequestid == null ? 43 : this.workRequestid.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private Long id;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="workRequestid")
        private String workRequestid;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(Long id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder workRequestid(String workRequestid) {
            this.workRequestid = workRequestid;
            this.__explicitlySet__.add("workRequestid");
            return this;
        }

        public WorkRequestLog build() {
            WorkRequestLog model = new WorkRequestLog(this.id, this.message, this.timestamp, this.workRequestid);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestLog model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("workRequestid")) {
                this.workRequestid(model.getWorkRequestid());
            }
            return this;
        }
    }
}

