/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.StatementOutputData;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StatementOutput
extends ExplicitlySetBmcModel {
    @JsonProperty(value="data")
    private final StatementOutputData data;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="errorName")
    private final String errorName;
    @JsonProperty(value="errorValue")
    private final String errorValue;
    @JsonProperty(value="traceback")
    private final List<String> traceback;

    @Deprecated
    @ConstructorProperties(value={"data", "status", "errorName", "errorValue", "traceback"})
    public StatementOutput(StatementOutputData data, Status status, String errorName, String errorValue, List<String> traceback) {
        this.data = data;
        this.status = status;
        this.errorName = errorName;
        this.errorValue = errorValue;
        this.traceback = traceback;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public StatementOutputData getData() {
        return this.data;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorName() {
        return this.errorName;
    }

    public String getErrorValue() {
        return this.errorValue;
    }

    public List<String> getTraceback() {
        return this.traceback;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StatementOutput(");
        sb.append("super=").append(super.toString());
        sb.append("data=").append(String.valueOf((Object)this.data));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", errorName=").append(String.valueOf(this.errorName));
        sb.append(", errorValue=").append(String.valueOf(this.errorValue));
        sb.append(", traceback=").append(String.valueOf(this.traceback));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatementOutput)) {
            return false;
        }
        StatementOutput other = (StatementOutput)((Object)o);
        return Objects.equals((Object)this.data, (Object)other.data) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.errorName, other.errorName) && Objects.equals(this.errorValue, other.errorValue) && Objects.equals(this.traceback, other.traceback) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.data == null ? 43 : this.data.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.errorName == null ? 43 : this.errorName.hashCode());
        result = result * 59 + (this.errorValue == null ? 43 : this.errorValue.hashCode());
        result = result * 59 + (this.traceback == null ? 43 : this.traceback.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Ok("OK"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="data")
        private StatementOutputData data;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="errorName")
        private String errorName;
        @JsonProperty(value="errorValue")
        private String errorValue;
        @JsonProperty(value="traceback")
        private List<String> traceback;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder data(StatementOutputData data) {
            this.data = data;
            this.__explicitlySet__.add("data");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder errorName(String errorName) {
            this.errorName = errorName;
            this.__explicitlySet__.add("errorName");
            return this;
        }

        public Builder errorValue(String errorValue) {
            this.errorValue = errorValue;
            this.__explicitlySet__.add("errorValue");
            return this;
        }

        public Builder traceback(List<String> traceback) {
            this.traceback = traceback;
            this.__explicitlySet__.add("traceback");
            return this;
        }

        public StatementOutput build() {
            StatementOutput model = new StatementOutput(this.data, this.status, this.errorName, this.errorValue, this.traceback);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StatementOutput model) {
            if (model.wasPropertyExplicitlySet("data")) {
                this.data(model.getData());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("errorName")) {
                this.errorName(model.getErrorName());
            }
            if (model.wasPropertyExplicitlySet("errorValue")) {
                this.errorValue(model.getErrorValue());
            }
            if (model.wasPropertyExplicitlySet("traceback")) {
                this.traceback(model.getTraceback());
            }
            return this;
        }
    }
}

