/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.StatementLifecycleState;
import com.oracle.bmc.dataflow.model.StatementOutput;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Statement
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final Long id;
    @JsonProperty(value="code")
    private final String code;
    @JsonProperty(value="lifecycleState")
    private final StatementLifecycleState lifecycleState;
    @JsonProperty(value="output")
    private final StatementOutput output;
    @JsonProperty(value="progress")
    private final Double progress;
    @JsonProperty(value="runId")
    private final String runId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeCompleted")
    private final Date timeCompleted;

    @Deprecated
    @ConstructorProperties(value={"id", "code", "lifecycleState", "output", "progress", "runId", "timeCreated", "timeCompleted"})
    public Statement(Long id, String code, StatementLifecycleState lifecycleState, StatementOutput output, Double progress, String runId, Date timeCreated, Date timeCompleted) {
        this.id = id;
        this.code = code;
        this.lifecycleState = lifecycleState;
        this.output = output;
        this.progress = progress;
        this.runId = runId;
        this.timeCreated = timeCreated;
        this.timeCompleted = timeCompleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public StatementLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public StatementOutput getOutput() {
        return this.output;
    }

    public Double getProgress() {
        return this.progress;
    }

    public String getRunId() {
        return this.runId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeCompleted() {
        return this.timeCompleted;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Statement(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", code=").append(String.valueOf(this.code));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", output=").append(String.valueOf((Object)this.output));
        sb.append(", progress=").append(String.valueOf(this.progress));
        sb.append(", runId=").append(String.valueOf(this.runId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeCompleted=").append(String.valueOf(this.timeCompleted));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.code, other.code) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.output, (Object)other.output) && Objects.equals(this.progress, other.progress) && Objects.equals(this.runId, other.runId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeCompleted, other.timeCompleted) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.code == null ? 43 : this.code.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.output == null ? 43 : this.output.hashCode());
        result = result * 59 + (this.progress == null ? 43 : this.progress.hashCode());
        result = result * 59 + (this.runId == null ? 43 : this.runId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeCompleted == null ? 43 : this.timeCompleted.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private Long id;
        @JsonProperty(value="code")
        private String code;
        @JsonProperty(value="lifecycleState")
        private StatementLifecycleState lifecycleState;
        @JsonProperty(value="output")
        private StatementOutput output;
        @JsonProperty(value="progress")
        private Double progress;
        @JsonProperty(value="runId")
        private String runId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeCompleted")
        private Date timeCompleted;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(Long id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.__explicitlySet__.add("code");
            return this;
        }

        public Builder lifecycleState(StatementLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder output(StatementOutput output) {
            this.output = output;
            this.__explicitlySet__.add("output");
            return this;
        }

        public Builder progress(Double progress) {
            this.progress = progress;
            this.__explicitlySet__.add("progress");
            return this;
        }

        public Builder runId(String runId) {
            this.runId = runId;
            this.__explicitlySet__.add("runId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeCompleted(Date timeCompleted) {
            this.timeCompleted = timeCompleted;
            this.__explicitlySet__.add("timeCompleted");
            return this;
        }

        public Statement build() {
            Statement model = new Statement(this.id, this.code, this.lifecycleState, this.output, this.progress, this.runId, this.timeCreated, this.timeCompleted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Statement model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("code")) {
                this.code(model.getCode());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("output")) {
                this.output(model.getOutput());
            }
            if (model.wasPropertyExplicitlySet("progress")) {
                this.progress(model.getProgress());
            }
            if (model.wasPropertyExplicitlySet("runId")) {
                this.runId(model.getRunId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeCompleted")) {
                this.timeCompleted(model.getTimeCompleted());
            }
            return this;
        }
    }
}

