/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RunLogSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="runId")
    private final String runId;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="source")
    private final Source source;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="type")
    private final Type type;

    @Deprecated
    @ConstructorProperties(value={"name", "runId", "sizeInBytes", "source", "timeCreated", "type"})
    public RunLogSummary(String name, String runId, Long sizeInBytes, Source source, Date timeCreated, Type type) {
        this.name = name;
        this.runId = runId;
        this.sizeInBytes = sizeInBytes;
        this.source = source;
        this.timeCreated = timeCreated;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getRunId() {
        return this.runId;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Source getSource() {
        return this.source;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RunLogSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", runId=").append(String.valueOf(this.runId));
        sb.append(", sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RunLogSummary)) {
            return false;
        }
        RunLogSummary other = (RunLogSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.runId, other.runId) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.type, (Object)other.type) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.runId == null ? 43 : this.runId.hashCode());
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Stderr("STDERR"),
        Stdout("STDOUT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Source implements BmcEnum
    {
        Application("APPLICATION"),
        Driver("DRIVER"),
        Executor("EXECUTOR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Source> map;

        private Source(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Source create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Source', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Source.class);
            map = new HashMap<String, Source>();
            for (Source v : Source.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="runId")
        private String runId;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="source")
        private Source source;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="type")
        private Type type;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder runId(String runId) {
            this.runId = runId;
            this.__explicitlySet__.add("runId");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public RunLogSummary build() {
            RunLogSummary model = new RunLogSummary(this.name, this.runId, this.sizeInBytes, this.source, this.timeCreated, this.type);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RunLogSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("runId")) {
                this.runId(model.getRunId());
            }
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            return this;
        }
    }
}

