/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow;

import com.oracle.bmc.dataflow.DataFlow;
import com.oracle.bmc.dataflow.model.ApplicationSummary;
import com.oracle.bmc.dataflow.model.PrivateEndpointSummary;
import com.oracle.bmc.dataflow.model.RunLogSummary;
import com.oracle.bmc.dataflow.model.RunSummary;
import com.oracle.bmc.dataflow.model.StatementSummary;
import com.oracle.bmc.dataflow.model.WorkRequestError;
import com.oracle.bmc.dataflow.model.WorkRequestLog;
import com.oracle.bmc.dataflow.model.WorkRequestSummary;
import com.oracle.bmc.dataflow.requests.ListApplicationsRequest;
import com.oracle.bmc.dataflow.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListRunLogsRequest;
import com.oracle.bmc.dataflow.requests.ListRunsRequest;
import com.oracle.bmc.dataflow.requests.ListStatementsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataflow.responses.ListApplicationsResponse;
import com.oracle.bmc.dataflow.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListRunLogsResponse;
import com.oracle.bmc.dataflow.responses.ListRunsResponse;
import com.oracle.bmc.dataflow.responses.ListStatementsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DataFlowPaginators {
    private final DataFlow client;

    public DataFlowPaginators(DataFlow client) {
        this.client = client;
    }

    public Iterable<ListApplicationsResponse> listApplicationsResponseIterator(final ListApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            @Override
            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            @Override
            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            @Override
            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            @Override
            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return DataFlowPaginators.this.client.listApplications(request);
            }
        });
    }

    public Iterable<ApplicationSummary> listApplicationsRecordIterator(final ListApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            @Override
            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            @Override
            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            @Override
            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            @Override
            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return DataFlowPaginators.this.client.listApplications(request);
            }
        }, (Function)new Function<ListApplicationsResponse, List<ApplicationSummary>>(){

            @Override
            public List<ApplicationSummary> apply(ListApplicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPrivateEndpointsResponse> listPrivateEndpointsResponseIterator(final ListPrivateEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPrivateEndpointsRequest.Builder>(){

            @Override
            public ListPrivateEndpointsRequest.Builder get() {
                return ListPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder>, ListPrivateEndpointsRequest>(){

            @Override
            public ListPrivateEndpointsRequest apply(RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>(){

            @Override
            public ListPrivateEndpointsResponse apply(ListPrivateEndpointsRequest request) {
                return DataFlowPaginators.this.client.listPrivateEndpoints(request);
            }
        });
    }

    public Iterable<PrivateEndpointSummary> listPrivateEndpointsRecordIterator(final ListPrivateEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPrivateEndpointsRequest.Builder>(){

            @Override
            public ListPrivateEndpointsRequest.Builder get() {
                return ListPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder>, ListPrivateEndpointsRequest>(){

            @Override
            public ListPrivateEndpointsRequest apply(RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>(){

            @Override
            public ListPrivateEndpointsResponse apply(ListPrivateEndpointsRequest request) {
                return DataFlowPaginators.this.client.listPrivateEndpoints(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, List<PrivateEndpointSummary>>(){

            @Override
            public List<PrivateEndpointSummary> apply(ListPrivateEndpointsResponse response) {
                return response.getPrivateEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListRunLogsResponse> listRunLogsResponseIterator(final ListRunLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRunLogsRequest.Builder>(){

            @Override
            public ListRunLogsRequest.Builder get() {
                return ListRunLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunLogsResponse, String>(){

            @Override
            public String apply(ListRunLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunLogsRequest.Builder>, ListRunLogsRequest>(){

            @Override
            public ListRunLogsRequest apply(RequestBuilderAndToken<ListRunLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRunLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRunLogsRequest, ListRunLogsResponse>(){

            @Override
            public ListRunLogsResponse apply(ListRunLogsRequest request) {
                return DataFlowPaginators.this.client.listRunLogs(request);
            }
        });
    }

    public Iterable<RunLogSummary> listRunLogsRecordIterator(final ListRunLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRunLogsRequest.Builder>(){

            @Override
            public ListRunLogsRequest.Builder get() {
                return ListRunLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunLogsResponse, String>(){

            @Override
            public String apply(ListRunLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunLogsRequest.Builder>, ListRunLogsRequest>(){

            @Override
            public ListRunLogsRequest apply(RequestBuilderAndToken<ListRunLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRunLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRunLogsRequest, ListRunLogsResponse>(){

            @Override
            public ListRunLogsResponse apply(ListRunLogsRequest request) {
                return DataFlowPaginators.this.client.listRunLogs(request);
            }
        }, (Function)new Function<ListRunLogsResponse, List<RunLogSummary>>(){

            @Override
            public List<RunLogSummary> apply(ListRunLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListRunsResponse> listRunsResponseIterator(final ListRunsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRunsRequest.Builder>(){

            @Override
            public ListRunsRequest.Builder get() {
                return ListRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunsResponse, String>(){

            @Override
            public String apply(ListRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunsRequest.Builder>, ListRunsRequest>(){

            @Override
            public ListRunsRequest apply(RequestBuilderAndToken<ListRunsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRunsRequest, ListRunsResponse>(){

            @Override
            public ListRunsResponse apply(ListRunsRequest request) {
                return DataFlowPaginators.this.client.listRuns(request);
            }
        });
    }

    public Iterable<RunSummary> listRunsRecordIterator(final ListRunsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRunsRequest.Builder>(){

            @Override
            public ListRunsRequest.Builder get() {
                return ListRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunsResponse, String>(){

            @Override
            public String apply(ListRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunsRequest.Builder>, ListRunsRequest>(){

            @Override
            public ListRunsRequest apply(RequestBuilderAndToken<ListRunsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRunsRequest, ListRunsResponse>(){

            @Override
            public ListRunsResponse apply(ListRunsRequest request) {
                return DataFlowPaginators.this.client.listRuns(request);
            }
        }, (Function)new Function<ListRunsResponse, List<RunSummary>>(){

            @Override
            public List<RunSummary> apply(ListRunsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListStatementsResponse> listStatementsResponseIterator(final ListStatementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStatementsRequest.Builder>(){

            @Override
            public ListStatementsRequest.Builder get() {
                return ListStatementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStatementsResponse, String>(){

            @Override
            public String apply(ListStatementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStatementsRequest.Builder>, ListStatementsRequest>(){

            @Override
            public ListStatementsRequest apply(RequestBuilderAndToken<ListStatementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStatementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStatementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStatementsRequest, ListStatementsResponse>(){

            @Override
            public ListStatementsResponse apply(ListStatementsRequest request) {
                return DataFlowPaginators.this.client.listStatements(request);
            }
        });
    }

    public Iterable<StatementSummary> listStatementsRecordIterator(final ListStatementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStatementsRequest.Builder>(){

            @Override
            public ListStatementsRequest.Builder get() {
                return ListStatementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStatementsResponse, String>(){

            @Override
            public String apply(ListStatementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStatementsRequest.Builder>, ListStatementsRequest>(){

            @Override
            public ListStatementsRequest apply(RequestBuilderAndToken<ListStatementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStatementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStatementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStatementsRequest, ListStatementsResponse>(){

            @Override
            public ListStatementsResponse apply(ListStatementsRequest request) {
                return DataFlowPaginators.this.client.listStatements(request);
            }
        }, (Function)new Function<ListStatementsResponse, List<StatementSummary>>(){

            @Override
            public List<StatementSummary> apply(ListStatementsResponse response) {
                return response.getStatementCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLog> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLog>>(){

            @Override
            public List<WorkRequestLog> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

