/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListSchemasRequest
extends BmcRequest<Void> {
    private String registryId;
    private String connectionKey;
    private String page;
    private Integer limit;
    private List<String> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String schemaResourceKey;
    private String name;
    private String opcRequestId;
    private List<String> nameList;
    private String endpointId;
    private List<String> includeTypes;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getSchemaResourceKey() {
        return this.schemaResourceKey;
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public List<String> getIncludeTypes() {
        return this.includeTypes;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).connectionKey(this.connectionKey).page(this.page).limit(this.limit).fields(this.fields).sortBy(this.sortBy).sortOrder(this.sortOrder).schemaResourceKey(this.schemaResourceKey).name(this.name).opcRequestId(this.opcRequestId).nameList(this.nameList).endpointId(this.endpointId).includeTypes(this.includeTypes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",schemaResourceKey=").append(String.valueOf(this.schemaResourceKey));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",nameList=").append(String.valueOf(this.nameList));
        sb.append(",endpointId=").append(String.valueOf(this.endpointId));
        sb.append(",includeTypes=").append(String.valueOf(this.includeTypes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSchemasRequest)) {
            return false;
        }
        ListSchemasRequest other = (ListSchemasRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.schemaResourceKey, other.schemaResourceKey) && Objects.equals(this.name, other.name) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.nameList, other.nameList) && Objects.equals(this.endpointId, other.endpointId) && Objects.equals(this.includeTypes, other.includeTypes);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.schemaResourceKey == null ? 43 : this.schemaResourceKey.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.nameList == null ? 43 : this.nameList.hashCode());
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        result = result * 59 + (this.includeTypes == null ? 43 : this.includeTypes.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSchemasRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String connectionKey = null;
        private String page = null;
        private Integer limit = null;
        private List<String> fields = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String schemaResourceKey = null;
        private String name = null;
        private String opcRequestId = null;
        private List<String> nameList = null;
        private String endpointId = null;
        private List<String> includeTypes = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder schemaResourceKey(String schemaResourceKey) {
            this.schemaResourceKey = schemaResourceKey;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder nameList(List<String> nameList) {
            this.nameList = nameList;
            return this;
        }

        public Builder nameList(String singularValue) {
            return this.nameList(Arrays.asList(singularValue));
        }

        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public Builder includeTypes(List<String> includeTypes) {
            this.includeTypes = includeTypes;
            return this;
        }

        public Builder includeTypes(String singularValue) {
            return this.includeTypes(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSchemasRequest o) {
            this.registryId(o.getRegistryId());
            this.connectionKey(o.getConnectionKey());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.schemaResourceKey(o.getSchemaResourceKey());
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.nameList(o.getNameList());
            this.endpointId(o.getEndpointId());
            this.includeTypes(o.getIncludeTypes());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSchemasRequest build() {
            ListSchemasRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSchemasRequest buildWithoutInvocationCallback() {
            ListSchemasRequest request = new ListSchemasRequest();
            request.registryId = this.registryId;
            request.connectionKey = this.connectionKey;
            request.page = this.page;
            request.limit = this.limit;
            request.fields = this.fields;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.schemaResourceKey = this.schemaResourceKey;
            request.name = this.name;
            request.opcRequestId = this.opcRequestId;
            request.nameList = this.nameList;
            request.endpointId = this.endpointId;
            request.includeTypes = this.includeTypes;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Id("id"),
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

