/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListRegistriesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String name;
    private Integer limit;
    private String page;
    private Boolean isDeepLookup;
    private LifecycleState lifecycleState;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getIsDeepLookup() {
        return this.isDeepLookup;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).name(this.name).limit(this.limit).page(this.page).isDeepLookup(this.isDeepLookup).lifecycleState(this.lifecycleState).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",isDeepLookup=").append(String.valueOf(this.isDeepLookup));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRegistriesRequest)) {
            return false;
        }
        ListRegistriesRequest other = (ListRegistriesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.isDeepLookup, other.isDeepLookup) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.isDeepLookup == null ? 43 : this.isDeepLookup.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRegistriesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String name = null;
        private Integer limit = null;
        private String page = null;
        private Boolean isDeepLookup = null;
        private LifecycleState lifecycleState = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder isDeepLookup(Boolean isDeepLookup) {
            this.isDeepLookup = isDeepLookup;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRegistriesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.name(o.getName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.isDeepLookup(o.getIsDeepLookup());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRegistriesRequest build() {
            ListRegistriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListRegistriesRequest buildWithoutInvocationCallback() {
            ListRegistriesRequest request = new ListRegistriesRequest();
            request.compartmentId = this.compartmentId;
            request.name = this.name;
            request.limit = this.limit;
            request.page = this.page;
            request.isDeepLookup = this.isDeepLookup;
            request.lifecycleState = this.lifecycleState;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        Starting("STARTING"),
        Stopping("STOPPING"),
        Stopped("STOPPED");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

