/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteNetworkConnectivityStatusRequest
extends BmcRequest<Void> {
    private String registryId;
    private String networkValidationStatusKey;
    private String opcRequestId;
    private String ifMatch;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getNetworkValidationStatusKey() {
        return this.networkValidationStatusKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).networkValidationStatusKey(this.networkValidationStatusKey).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",networkValidationStatusKey=").append(String.valueOf(this.networkValidationStatusKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteNetworkConnectivityStatusRequest)) {
            return false;
        }
        DeleteNetworkConnectivityStatusRequest other = (DeleteNetworkConnectivityStatusRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.networkValidationStatusKey, other.networkValidationStatusKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.networkValidationStatusKey == null ? 43 : this.networkValidationStatusKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteNetworkConnectivityStatusRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String networkValidationStatusKey = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder networkValidationStatusKey(String networkValidationStatusKey) {
            this.networkValidationStatusKey = networkValidationStatusKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteNetworkConnectivityStatusRequest o) {
            this.registryId(o.getRegistryId());
            this.networkValidationStatusKey(o.getNetworkValidationStatusKey());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteNetworkConnectivityStatusRequest build() {
            DeleteNetworkConnectivityStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteNetworkConnectivityStatusRequest buildWithoutInvocationCallback() {
            DeleteNetworkConnectivityStatusRequest request = new DeleteNetworkConnectivityStatusRequest();
            request.registryId = this.registryId;
            request.networkValidationStatusKey = this.networkValidationStatusKey;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

