/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataconnectivity.model.CreateDataAssetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateDataAssetRequest
extends BmcRequest<CreateDataAssetDetails> {
    private String registryId;
    private CreateDataAssetDetails createDataAssetDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getRegistryId() {
        return this.registryId;
    }

    public CreateDataAssetDetails getCreateDataAssetDetails() {
        return this.createDataAssetDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateDataAssetDetails getBody$() {
        return this.createDataAssetDetails;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).createDataAssetDetails(this.createDataAssetDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",createDataAssetDetails=").append(String.valueOf((Object)this.createDataAssetDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataAssetRequest)) {
            return false;
        }
        CreateDataAssetRequest other = (CreateDataAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals((Object)this.createDataAssetDetails, (Object)other.createDataAssetDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.createDataAssetDetails == null ? 43 : this.createDataAssetDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDataAssetRequest, CreateDataAssetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private CreateDataAssetDetails createDataAssetDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder createDataAssetDetails(CreateDataAssetDetails createDataAssetDetails) {
            this.createDataAssetDetails = createDataAssetDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDataAssetRequest o) {
            this.registryId(o.getRegistryId());
            this.createDataAssetDetails(o.getCreateDataAssetDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDataAssetRequest build() {
            CreateDataAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateDataAssetDetails body) {
            this.createDataAssetDetails(body);
            return this;
        }

        public CreateDataAssetRequest buildWithoutInvocationCallback() {
            CreateDataAssetRequest request = new CreateDataAssetRequest();
            request.registryId = this.registryId;
            request.createDataAssetDetails = this.createDataAssetDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

