/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.AbstractDataOperationConfig;
import com.oracle.bmc.dataconnectivity.model.AbstractWriteAttribute;
import com.oracle.bmc.dataconnectivity.model.DataFormat;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import com.oracle.bmc.dataconnectivity.model.PartitionConfig;
import com.oracle.bmc.dataconnectivity.model.PushDownOperation;
import com.oracle.bmc.dataconnectivity.model.UniqueKey;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class WriteOperationConfig
extends AbstractDataOperationConfig {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="operations")
    private final List<PushDownOperation> operations;
    @JsonProperty(value="dataFormat")
    private final DataFormat dataFormat;
    @JsonProperty(value="partitionConfig")
    private final PartitionConfig partitionConfig;
    @JsonProperty(value="writeAttribute")
    private final AbstractWriteAttribute writeAttribute;
    @JsonProperty(value="writeMode")
    private final WriteMode writeMode;
    @JsonProperty(value="mergeKey")
    private final UniqueKey mergeKey;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="rejectLimit")
    private final Integer rejectLimit;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public WriteOperationConfig(Map<String, String> derivedAttributes, String key, String modelVersion, ParentReference parentRef, List<PushDownOperation> operations, DataFormat dataFormat, PartitionConfig partitionConfig, AbstractWriteAttribute writeAttribute, WriteMode writeMode, UniqueKey mergeKey, Integer objectStatus, Integer rejectLimit) {
        super(derivedAttributes);
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.operations = operations;
        this.dataFormat = dataFormat;
        this.partitionConfig = partitionConfig;
        this.writeAttribute = writeAttribute;
        this.writeMode = writeMode;
        this.mergeKey = mergeKey;
        this.objectStatus = objectStatus;
        this.rejectLimit = rejectLimit;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public List<PushDownOperation> getOperations() {
        return this.operations;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public PartitionConfig getPartitionConfig() {
        return this.partitionConfig;
    }

    public AbstractWriteAttribute getWriteAttribute() {
        return this.writeAttribute;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public UniqueKey getMergeKey() {
        return this.mergeKey;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public Integer getRejectLimit() {
        return this.rejectLimit;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WriteOperationConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", operations=").append(String.valueOf(this.operations));
        sb.append(", dataFormat=").append(String.valueOf((Object)this.dataFormat));
        sb.append(", partitionConfig=").append(String.valueOf((Object)this.partitionConfig));
        sb.append(", writeAttribute=").append(String.valueOf((Object)this.writeAttribute));
        sb.append(", writeMode=").append(String.valueOf((Object)this.writeMode));
        sb.append(", mergeKey=").append(String.valueOf((Object)this.mergeKey));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", rejectLimit=").append(String.valueOf(this.rejectLimit));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriteOperationConfig)) {
            return false;
        }
        WriteOperationConfig other = (WriteOperationConfig)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.operations, other.operations) && Objects.equals((Object)this.dataFormat, (Object)other.dataFormat) && Objects.equals((Object)this.partitionConfig, (Object)other.partitionConfig) && Objects.equals((Object)this.writeAttribute, (Object)other.writeAttribute) && Objects.equals((Object)this.writeMode, (Object)other.writeMode) && Objects.equals((Object)this.mergeKey, (Object)other.mergeKey) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.rejectLimit, other.rejectLimit) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.operations == null ? 43 : this.operations.hashCode());
        result = result * 59 + (this.dataFormat == null ? 43 : this.dataFormat.hashCode());
        result = result * 59 + (this.partitionConfig == null ? 43 : this.partitionConfig.hashCode());
        result = result * 59 + (this.writeAttribute == null ? 43 : this.writeAttribute.hashCode());
        result = result * 59 + (this.writeMode == null ? 43 : this.writeMode.hashCode());
        result = result * 59 + (this.mergeKey == null ? 43 : this.mergeKey.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.rejectLimit == null ? 43 : this.rejectLimit.hashCode());
        return result;
    }

    public static enum WriteMode implements BmcEnum
    {
        Overwrite("OVERWRITE"),
        Append("APPEND"),
        Merge("MERGE"),
        Ignore("IGNORE"),
        Create("CREATE");

        private final String value;
        private static Map<String, WriteMode> map;

        private WriteMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WriteMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WriteMode: " + key);
        }

        static {
            map = new HashMap<String, WriteMode>();
            for (WriteMode v : WriteMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="derivedAttributes")
        private Map<String, String> derivedAttributes;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="operations")
        private List<PushDownOperation> operations;
        @JsonProperty(value="dataFormat")
        private DataFormat dataFormat;
        @JsonProperty(value="partitionConfig")
        private PartitionConfig partitionConfig;
        @JsonProperty(value="writeAttribute")
        private AbstractWriteAttribute writeAttribute;
        @JsonProperty(value="writeMode")
        private WriteMode writeMode;
        @JsonProperty(value="mergeKey")
        private UniqueKey mergeKey;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="rejectLimit")
        private Integer rejectLimit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder derivedAttributes(Map<String, String> derivedAttributes) {
            this.derivedAttributes = derivedAttributes;
            this.__explicitlySet__.add("derivedAttributes");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder operations(List<PushDownOperation> operations) {
            this.operations = operations;
            this.__explicitlySet__.add("operations");
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            this.__explicitlySet__.add("dataFormat");
            return this;
        }

        public Builder partitionConfig(PartitionConfig partitionConfig) {
            this.partitionConfig = partitionConfig;
            this.__explicitlySet__.add("partitionConfig");
            return this;
        }

        public Builder writeAttribute(AbstractWriteAttribute writeAttribute) {
            this.writeAttribute = writeAttribute;
            this.__explicitlySet__.add("writeAttribute");
            return this;
        }

        public Builder writeMode(WriteMode writeMode) {
            this.writeMode = writeMode;
            this.__explicitlySet__.add("writeMode");
            return this;
        }

        public Builder mergeKey(UniqueKey mergeKey) {
            this.mergeKey = mergeKey;
            this.__explicitlySet__.add("mergeKey");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder rejectLimit(Integer rejectLimit) {
            this.rejectLimit = rejectLimit;
            this.__explicitlySet__.add("rejectLimit");
            return this;
        }

        public WriteOperationConfig build() {
            WriteOperationConfig model = new WriteOperationConfig(this.derivedAttributes, this.key, this.modelVersion, this.parentRef, this.operations, this.dataFormat, this.partitionConfig, this.writeAttribute, this.writeMode, this.mergeKey, this.objectStatus, this.rejectLimit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WriteOperationConfig model) {
            if (model.wasPropertyExplicitlySet("derivedAttributes")) {
                this.derivedAttributes(model.getDerivedAttributes());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("operations")) {
                this.operations(model.getOperations());
            }
            if (model.wasPropertyExplicitlySet("dataFormat")) {
                this.dataFormat(model.getDataFormat());
            }
            if (model.wasPropertyExplicitlySet("partitionConfig")) {
                this.partitionConfig(model.getPartitionConfig());
            }
            if (model.wasPropertyExplicitlySet("writeAttribute")) {
                this.writeAttribute(model.getWriteAttribute());
            }
            if (model.wasPropertyExplicitlySet("writeMode")) {
                this.writeMode(model.getWriteMode());
            }
            if (model.wasPropertyExplicitlySet("mergeKey")) {
                this.mergeKey(model.getMergeKey());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("rejectLimit")) {
                this.rejectLimit(model.getRejectLimit());
            }
            return this;
        }
    }
}

