/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import com.oracle.bmc.dataconnectivity.model.ReferencedDataObjectFromAPI;
import com.oracle.bmc.dataconnectivity.model.ReferencedDataObjectFromProcedure;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=ReferencedDataObject.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ReferencedDataObjectFromAPI.class, name="API"), @JsonSubTypes.Type(value=ReferencedDataObjectFromProcedure.class, name="PROCEDURE")})
@JsonFilter(value="explicitlySetFilter")
public class ReferencedDataObject
extends ExplicitlySetBmcModel {
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="externalKey")
    private final String externalKey;

    @Deprecated
    @ConstructorProperties(value={"modelVersion", "parentRef", "name", "objectVersion", "resourceName", "objectStatus", "externalKey"})
    protected ReferencedDataObject(String modelVersion, ParentReference parentRef, String name, Integer objectVersion, String resourceName, Integer objectStatus, String externalKey) {
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.objectVersion = objectVersion;
        this.resourceName = resourceName;
        this.objectStatus = objectStatus;
        this.externalKey = externalKey;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReferencedDataObject(");
        sb.append("super=").append(super.toString());
        sb.append("modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", externalKey=").append(String.valueOf(this.externalKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferencedDataObject)) {
            return false;
        }
        ReferencedDataObject other = (ReferencedDataObject)((Object)o);
        return Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.externalKey, other.externalKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.externalKey == null ? 43 : this.externalKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        Procedure("PROCEDURE"),
        Api("API"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

