/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProfileConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="attributes")
    private final List<String> attributes;
    @JsonProperty(value="functions")
    private final List<Functions> functions;
    @JsonProperty(value="topNValFreq")
    private final Integer topNValFreq;
    @JsonProperty(value="patternThreshold")
    private final Integer patternThreshold;
    @JsonProperty(value="dataTypeThreshold")
    private final Integer dataTypeThreshold;

    @Deprecated
    @ConstructorProperties(value={"attributes", "functions", "topNValFreq", "patternThreshold", "dataTypeThreshold"})
    public ProfileConfig(List<String> attributes, List<Functions> functions, Integer topNValFreq, Integer patternThreshold, Integer dataTypeThreshold) {
        this.attributes = attributes;
        this.functions = functions;
        this.topNValFreq = topNValFreq;
        this.patternThreshold = patternThreshold;
        this.dataTypeThreshold = dataTypeThreshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public List<Functions> getFunctions() {
        return this.functions;
    }

    public Integer getTopNValFreq() {
        return this.topNValFreq;
    }

    public Integer getPatternThreshold() {
        return this.patternThreshold;
    }

    public Integer getDataTypeThreshold() {
        return this.dataTypeThreshold;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProfileConfig(");
        sb.append("super=").append(super.toString());
        sb.append("attributes=").append(String.valueOf(this.attributes));
        sb.append(", functions=").append(String.valueOf(this.functions));
        sb.append(", topNValFreq=").append(String.valueOf(this.topNValFreq));
        sb.append(", patternThreshold=").append(String.valueOf(this.patternThreshold));
        sb.append(", dataTypeThreshold=").append(String.valueOf(this.dataTypeThreshold));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileConfig)) {
            return false;
        }
        ProfileConfig other = (ProfileConfig)((Object)o);
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.functions, other.functions) && Objects.equals(this.topNValFreq, other.topNValFreq) && Objects.equals(this.patternThreshold, other.patternThreshold) && Objects.equals(this.dataTypeThreshold, other.dataTypeThreshold) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.attributes == null ? 43 : this.attributes.hashCode());
        result = result * 59 + (this.functions == null ? 43 : this.functions.hashCode());
        result = result * 59 + (this.topNValFreq == null ? 43 : this.topNValFreq.hashCode());
        result = result * 59 + (this.patternThreshold == null ? 43 : this.patternThreshold.hashCode());
        result = result * 59 + (this.dataTypeThreshold == null ? 43 : this.dataTypeThreshold.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Functions implements BmcEnum
    {
        AttributeCount("ATTRIBUTE_COUNT"),
        RowCount("ROW_COUNT"),
        DataType("DATA_TYPE"),
        DistinctCount("DISTINCT_COUNT"),
        DuplicateCount("DUPLICATE_COUNT"),
        Histogram("HISTOGRAM"),
        Max("MAX"),
        MaxLength("MAX_LENGTH"),
        Mean("MEAN"),
        MeanLength("MEAN_LENGTH"),
        Median("MEDIAN"),
        Min("MIN"),
        MinLength("MIN_LENGTH"),
        NullCount("NULL_COUNT"),
        Outlier("OUTLIER"),
        Pattern("PATTERN"),
        StandardDeviation("STANDARD_DEVIATION"),
        UniqueCount("UNIQUE_COUNT"),
        Variance("VARIANCE"),
        ValueFrequency("VALUE_FREQUENCY");

        private final String value;
        private static Map<String, Functions> map;

        private Functions(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Functions create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Functions: " + key);
        }

        static {
            map = new HashMap<String, Functions>();
            for (Functions v : Functions.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="attributes")
        private List<String> attributes;
        @JsonProperty(value="functions")
        private List<Functions> functions;
        @JsonProperty(value="topNValFreq")
        private Integer topNValFreq;
        @JsonProperty(value="patternThreshold")
        private Integer patternThreshold;
        @JsonProperty(value="dataTypeThreshold")
        private Integer dataTypeThreshold;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder attributes(List<String> attributes) {
            this.attributes = attributes;
            this.__explicitlySet__.add("attributes");
            return this;
        }

        public Builder functions(List<Functions> functions) {
            this.functions = functions;
            this.__explicitlySet__.add("functions");
            return this;
        }

        public Builder topNValFreq(Integer topNValFreq) {
            this.topNValFreq = topNValFreq;
            this.__explicitlySet__.add("topNValFreq");
            return this;
        }

        public Builder patternThreshold(Integer patternThreshold) {
            this.patternThreshold = patternThreshold;
            this.__explicitlySet__.add("patternThreshold");
            return this;
        }

        public Builder dataTypeThreshold(Integer dataTypeThreshold) {
            this.dataTypeThreshold = dataTypeThreshold;
            this.__explicitlySet__.add("dataTypeThreshold");
            return this;
        }

        public ProfileConfig build() {
            ProfileConfig model = new ProfileConfig(this.attributes, this.functions, this.topNValFreq, this.patternThreshold, this.dataTypeThreshold);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProfileConfig model) {
            if (model.wasPropertyExplicitlySet("attributes")) {
                this.attributes(model.getAttributes());
            }
            if (model.wasPropertyExplicitlySet("functions")) {
                this.functions(model.getFunctions());
            }
            if (model.wasPropertyExplicitlySet("topNValFreq")) {
                this.topNValFreq(model.getTopNValFreq());
            }
            if (model.wasPropertyExplicitlySet("patternThreshold")) {
                this.patternThreshold(model.getPatternThreshold());
            }
            if (model.wasPropertyExplicitlySet("dataTypeThreshold")) {
                this.dataTypeThreshold(model.getDataTypeThreshold());
            }
            return this;
        }
    }
}

