/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.KeyRange;
import com.oracle.bmc.dataconnectivity.model.PartitionConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class KeyRangePartitionConfig
extends PartitionConfig {
    @JsonProperty(value="partitionNumber")
    private final Integer partitionNumber;
    @JsonProperty(value="keyRange")
    private final KeyRange keyRange;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public KeyRangePartitionConfig(Integer partitionNumber, KeyRange keyRange) {
        this.partitionNumber = partitionNumber;
        this.keyRange = keyRange;
    }

    public Integer getPartitionNumber() {
        return this.partitionNumber;
    }

    public KeyRange getKeyRange() {
        return this.keyRange;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyRangePartitionConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", partitionNumber=").append(String.valueOf(this.partitionNumber));
        sb.append(", keyRange=").append(String.valueOf((Object)this.keyRange));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyRangePartitionConfig)) {
            return false;
        }
        KeyRangePartitionConfig other = (KeyRangePartitionConfig)((Object)o);
        return Objects.equals(this.partitionNumber, other.partitionNumber) && Objects.equals((Object)this.keyRange, (Object)other.keyRange) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.partitionNumber == null ? 43 : this.partitionNumber.hashCode());
        result = result * 59 + (this.keyRange == null ? 43 : this.keyRange.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="partitionNumber")
        private Integer partitionNumber;
        @JsonProperty(value="keyRange")
        private KeyRange keyRange;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            this.__explicitlySet__.add("partitionNumber");
            return this;
        }

        public Builder keyRange(KeyRange keyRange) {
            this.keyRange = keyRange;
            this.__explicitlySet__.add("keyRange");
            return this;
        }

        public KeyRangePartitionConfig build() {
            KeyRangePartitionConfig model = new KeyRangePartitionConfig(this.partitionNumber, this.keyRange);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KeyRangePartitionConfig model) {
            if (model.wasPropertyExplicitlySet("partitionNumber")) {
                this.partitionNumber(model.getPartitionNumber());
            }
            if (model.wasPropertyExplicitlySet("keyRange")) {
                this.keyRange(model.getKeyRange());
            }
            return this;
        }
    }
}

