/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Histogram
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ranges")
    private final List<String> ranges;
    @JsonProperty(value="counts")
    private final List<Integer> counts;

    @Deprecated
    @ConstructorProperties(value={"ranges", "counts"})
    public Histogram(List<String> ranges, List<Integer> counts) {
        this.ranges = ranges;
        this.counts = counts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getRanges() {
        return this.ranges;
    }

    public List<Integer> getCounts() {
        return this.counts;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Histogram(");
        sb.append("super=").append(super.toString());
        sb.append("ranges=").append(String.valueOf(this.ranges));
        sb.append(", counts=").append(String.valueOf(this.counts));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Histogram)) {
            return false;
        }
        Histogram other = (Histogram)((Object)o);
        return Objects.equals(this.ranges, other.ranges) && Objects.equals(this.counts, other.counts) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ranges == null ? 43 : this.ranges.hashCode());
        result = result * 59 + (this.counts == null ? 43 : this.counts.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ranges")
        private List<String> ranges;
        @JsonProperty(value="counts")
        private List<Integer> counts;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ranges(List<String> ranges) {
            this.ranges = ranges;
            this.__explicitlySet__.add("ranges");
            return this;
        }

        public Builder counts(List<Integer> counts) {
            this.counts = counts;
            this.__explicitlySet__.add("counts");
            return this;
        }

        public Histogram build() {
            Histogram model = new Histogram(this.ranges, this.counts);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Histogram model) {
            if (model.wasPropertyExplicitlySet("ranges")) {
                this.ranges(model.getRanges());
            }
            if (model.wasPropertyExplicitlySet("counts")) {
                this.counts(model.getCounts());
            }
            return this;
        }
    }
}

