/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FullPushDownTaskResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="status")
    private final String status;

    @Deprecated
    @ConstructorProperties(value={"modelType", "errorMessage", "status"})
    public FullPushDownTaskResponse(String modelType, String errorMessage, String status) {
        this.modelType = modelType;
        this.errorMessage = errorMessage;
        this.status = status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FullPushDownTaskResponse(");
        sb.append("super=").append(super.toString());
        sb.append("modelType=").append(String.valueOf(this.modelType));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FullPushDownTaskResponse)) {
            return false;
        }
        FullPushDownTaskResponse other = (FullPushDownTaskResponse)((Object)o);
        return Objects.equals(this.modelType, other.modelType) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.status, other.status) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="status")
        private String status;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public FullPushDownTaskResponse build() {
            FullPushDownTaskResponse model = new FullPushDownTaskResponse(this.modelType, this.errorMessage, this.status);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FullPushDownTaskResponse model) {
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            return this;
        }
    }
}

