/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.Key;
import com.oracle.bmc.dataconnectivity.model.KeyAttribute;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import com.oracle.bmc.dataconnectivity.model.UniqueKey;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ForeignKey
extends Key {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="attributeRefs")
    private final List<KeyAttribute> attributeRefs;
    @JsonProperty(value="updateRule")
    private final Integer updateRule;
    @JsonProperty(value="deleteRule")
    private final Integer deleteRule;
    @JsonProperty(value="referenceUniqueKey")
    private final UniqueKey referenceUniqueKey;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ForeignKey(String key, String modelVersion, ParentReference parentRef, String name, List<KeyAttribute> attributeRefs, Integer updateRule, Integer deleteRule, UniqueKey referenceUniqueKey, Integer objectStatus) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.attributeRefs = attributeRefs;
        this.updateRule = updateRule;
        this.deleteRule = deleteRule;
        this.referenceUniqueKey = referenceUniqueKey;
        this.objectStatus = objectStatus;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public List<KeyAttribute> getAttributeRefs() {
        return this.attributeRefs;
    }

    public Integer getUpdateRule() {
        return this.updateRule;
    }

    public Integer getDeleteRule() {
        return this.deleteRule;
    }

    public UniqueKey getReferenceUniqueKey() {
        return this.referenceUniqueKey;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ForeignKey(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", attributeRefs=").append(String.valueOf(this.attributeRefs));
        sb.append(", updateRule=").append(String.valueOf(this.updateRule));
        sb.append(", deleteRule=").append(String.valueOf(this.deleteRule));
        sb.append(", referenceUniqueKey=").append(String.valueOf((Object)this.referenceUniqueKey));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ForeignKey)) {
            return false;
        }
        ForeignKey other = (ForeignKey)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.attributeRefs, other.attributeRefs) && Objects.equals(this.updateRule, other.updateRule) && Objects.equals(this.deleteRule, other.deleteRule) && Objects.equals((Object)this.referenceUniqueKey, (Object)other.referenceUniqueKey) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.attributeRefs == null ? 43 : this.attributeRefs.hashCode());
        result = result * 59 + (this.updateRule == null ? 43 : this.updateRule.hashCode());
        result = result * 59 + (this.deleteRule == null ? 43 : this.deleteRule.hashCode());
        result = result * 59 + (this.referenceUniqueKey == null ? 43 : this.referenceUniqueKey.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="attributeRefs")
        private List<KeyAttribute> attributeRefs;
        @JsonProperty(value="updateRule")
        private Integer updateRule;
        @JsonProperty(value="deleteRule")
        private Integer deleteRule;
        @JsonProperty(value="referenceUniqueKey")
        private UniqueKey referenceUniqueKey;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder attributeRefs(List<KeyAttribute> attributeRefs) {
            this.attributeRefs = attributeRefs;
            this.__explicitlySet__.add("attributeRefs");
            return this;
        }

        public Builder updateRule(Integer updateRule) {
            this.updateRule = updateRule;
            this.__explicitlySet__.add("updateRule");
            return this;
        }

        public Builder deleteRule(Integer deleteRule) {
            this.deleteRule = deleteRule;
            this.__explicitlySet__.add("deleteRule");
            return this;
        }

        public Builder referenceUniqueKey(UniqueKey referenceUniqueKey) {
            this.referenceUniqueKey = referenceUniqueKey;
            this.__explicitlySet__.add("referenceUniqueKey");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public ForeignKey build() {
            ForeignKey model = new ForeignKey(this.key, this.modelVersion, this.parentRef, this.name, this.attributeRefs, this.updateRule, this.deleteRule, this.referenceUniqueKey, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ForeignKey model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("attributeRefs")) {
                this.attributeRefs(model.getAttributeRefs());
            }
            if (model.wasPropertyExplicitlySet("updateRule")) {
                this.updateRule(model.getUpdateRule());
            }
            if (model.wasPropertyExplicitlySet("deleteRule")) {
                this.deleteRule(model.getDeleteRule());
            }
            if (model.wasPropertyExplicitlySet("referenceUniqueKey")) {
                this.referenceUniqueKey(model.getReferenceUniqueKey());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

