/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.OperationExecResult;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExecuteOperationJob
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationStatus")
    private final String operationStatus;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="operationName")
    private final String operationName;
    @JsonProperty(value="outParams")
    private final List<String> outParams;
    @JsonProperty(value="operationResult")
    private final List<OperationExecResult> operationResult;

    @Deprecated
    @ConstructorProperties(value={"operationStatus", "errorMessage", "operationName", "outParams", "operationResult"})
    public ExecuteOperationJob(String operationStatus, String errorMessage, String operationName, List<String> outParams, List<OperationExecResult> operationResult) {
        this.operationStatus = operationStatus;
        this.errorMessage = errorMessage;
        this.operationName = operationName;
        this.outParams = outParams;
        this.operationResult = operationResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOperationStatus() {
        return this.operationStatus;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public List<String> getOutParams() {
        return this.outParams;
    }

    public List<OperationExecResult> getOperationResult() {
        return this.operationResult;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecuteOperationJob(");
        sb.append("super=").append(super.toString());
        sb.append("operationStatus=").append(String.valueOf(this.operationStatus));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", operationName=").append(String.valueOf(this.operationName));
        sb.append(", outParams=").append(String.valueOf(this.outParams));
        sb.append(", operationResult=").append(String.valueOf(this.operationResult));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecuteOperationJob)) {
            return false;
        }
        ExecuteOperationJob other = (ExecuteOperationJob)((Object)o);
        return Objects.equals(this.operationStatus, other.operationStatus) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.operationName, other.operationName) && Objects.equals(this.outParams, other.outParams) && Objects.equals(this.operationResult, other.operationResult) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationStatus == null ? 43 : this.operationStatus.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.operationName == null ? 43 : this.operationName.hashCode());
        result = result * 59 + (this.outParams == null ? 43 : this.outParams.hashCode());
        result = result * 59 + (this.operationResult == null ? 43 : this.operationResult.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationStatus")
        private String operationStatus;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="outParams")
        private List<String> outParams;
        @JsonProperty(value="operationResult")
        private List<OperationExecResult> operationResult;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            this.__explicitlySet__.add("operationStatus");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            this.__explicitlySet__.add("operationName");
            return this;
        }

        public Builder outParams(List<String> outParams) {
            this.outParams = outParams;
            this.__explicitlySet__.add("outParams");
            return this;
        }

        public Builder operationResult(List<OperationExecResult> operationResult) {
            this.operationResult = operationResult;
            this.__explicitlySet__.add("operationResult");
            return this;
        }

        public ExecuteOperationJob build() {
            ExecuteOperationJob model = new ExecuteOperationJob(this.operationStatus, this.errorMessage, this.operationName, this.outParams, this.operationResult);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExecuteOperationJob model) {
            if (model.wasPropertyExplicitlySet("operationStatus")) {
                this.operationStatus(model.getOperationStatus());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("operationName")) {
                this.operationName(model.getOperationName());
            }
            if (model.wasPropertyExplicitlySet("outParams")) {
                this.outParams(model.getOutParams());
            }
            if (model.wasPropertyExplicitlySet("operationResult")) {
                this.operationResult(model.getOperationResult());
            }
            return this;
        }
    }
}

