/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.DataEntity;
import com.oracle.bmc.dataconnectivity.model.ObjectMetadata;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import com.oracle.bmc.dataconnectivity.model.ReferencedDataObject;
import com.oracle.bmc.dataconnectivity.model.Shape;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class DerivedEntity
extends DataEntity {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="shape")
    private final Shape shape;
    @JsonProperty(value="shapeId")
    private final String shapeId;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="refDataObject")
    private final ReferencedDataObject refDataObject;
    @JsonProperty(value="mode")
    private final Mode mode;
    @JsonProperty(value="derivedProperties")
    private final Map<String, Object> derivedProperties;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DerivedEntity(Map<String, String> entityProperties, ObjectMetadata metadata, String key, String modelVersion, ParentReference parentRef, String name, Integer objectVersion, Shape shape, String shapeId, String resourceName, Integer objectStatus, String identifier, ReferencedDataObject refDataObject, Mode mode, Map<String, Object> derivedProperties) {
        super(entityProperties, metadata);
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.objectVersion = objectVersion;
        this.shape = shape;
        this.shapeId = shapeId;
        this.resourceName = resourceName;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.refDataObject = refDataObject;
        this.mode = mode;
        this.derivedProperties = derivedProperties;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getShapeId() {
        return this.shapeId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ReferencedDataObject getRefDataObject() {
        return this.refDataObject;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Map<String, Object> getDerivedProperties() {
        return this.derivedProperties;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DerivedEntity(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", shape=").append(String.valueOf((Object)this.shape));
        sb.append(", shapeId=").append(String.valueOf(this.shapeId));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", refDataObject=").append(String.valueOf((Object)this.refDataObject));
        sb.append(", mode=").append(String.valueOf((Object)this.mode));
        sb.append(", derivedProperties=").append(String.valueOf(this.derivedProperties));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DerivedEntity)) {
            return false;
        }
        DerivedEntity other = (DerivedEntity)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals((Object)this.shape, (Object)other.shape) && Objects.equals(this.shapeId, other.shapeId) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.refDataObject, (Object)other.refDataObject) && Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.derivedProperties, other.derivedProperties) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.shapeId == null ? 43 : this.shapeId.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.refDataObject == null ? 43 : this.refDataObject.hashCode());
        result = result * 59 + (this.mode == null ? 43 : this.mode.hashCode());
        result = result * 59 + (this.derivedProperties == null ? 43 : this.derivedProperties.hashCode());
        return result;
    }

    public static enum Mode implements BmcEnum
    {
        In("IN"),
        Out("OUT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Mode> map;

        private Mode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Mode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Mode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Mode.class);
            map = new HashMap<String, Mode>();
            for (Mode v : Mode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityProperties")
        private Map<String, String> entityProperties;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="shape")
        private Shape shape;
        @JsonProperty(value="shapeId")
        private String shapeId;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="refDataObject")
        private ReferencedDataObject refDataObject;
        @JsonProperty(value="mode")
        private Mode mode;
        @JsonProperty(value="derivedProperties")
        private Map<String, Object> derivedProperties;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityProperties(Map<String, String> entityProperties) {
            this.entityProperties = entityProperties;
            this.__explicitlySet__.add("entityProperties");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder shapeId(String shapeId) {
            this.shapeId = shapeId;
            this.__explicitlySet__.add("shapeId");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder refDataObject(ReferencedDataObject refDataObject) {
            this.refDataObject = refDataObject;
            this.__explicitlySet__.add("refDataObject");
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            this.__explicitlySet__.add("mode");
            return this;
        }

        public Builder derivedProperties(Map<String, Object> derivedProperties) {
            this.derivedProperties = derivedProperties;
            this.__explicitlySet__.add("derivedProperties");
            return this;
        }

        public DerivedEntity build() {
            DerivedEntity model = new DerivedEntity(this.entityProperties, this.metadata, this.key, this.modelVersion, this.parentRef, this.name, this.objectVersion, this.shape, this.shapeId, this.resourceName, this.objectStatus, this.identifier, this.refDataObject, this.mode, this.derivedProperties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DerivedEntity model) {
            if (model.wasPropertyExplicitlySet("entityProperties")) {
                this.entityProperties(model.getEntityProperties());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("shapeId")) {
                this.shapeId(model.getShapeId());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("refDataObject")) {
                this.refDataObject(model.getRefDataObject());
            }
            if (model.wasPropertyExplicitlySet("mode")) {
                this.mode(model.getMode());
            }
            if (model.wasPropertyExplicitlySet("derivedProperties")) {
                this.derivedProperties(model.getDerivedProperties());
            }
            return this;
        }
    }
}

