/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataTypeStat
extends ExplicitlySetBmcModel {
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="confidence")
    private final Integer confidence;
    @JsonProperty(value="freq")
    private final Long freq;
    @JsonProperty(value="freqPercentage")
    private final Double freqPercentage;

    @Deprecated
    @ConstructorProperties(value={"value", "confidence", "freq", "freqPercentage"})
    public DataTypeStat(String value, Integer confidence, Long freq, Double freqPercentage) {
        this.value = value;
        this.confidence = confidence;
        this.freq = freq;
        this.freqPercentage = freqPercentage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getValue() {
        return this.value;
    }

    public Integer getConfidence() {
        return this.confidence;
    }

    public Long getFreq() {
        return this.freq;
    }

    public Double getFreqPercentage() {
        return this.freqPercentage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataTypeStat(");
        sb.append("super=").append(super.toString());
        sb.append("value=").append(String.valueOf(this.value));
        sb.append(", confidence=").append(String.valueOf(this.confidence));
        sb.append(", freq=").append(String.valueOf(this.freq));
        sb.append(", freqPercentage=").append(String.valueOf(this.freqPercentage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataTypeStat)) {
            return false;
        }
        DataTypeStat other = (DataTypeStat)((Object)o);
        return Objects.equals(this.value, other.value) && Objects.equals(this.confidence, other.confidence) && Objects.equals(this.freq, other.freq) && Objects.equals(this.freqPercentage, other.freqPercentage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.confidence == null ? 43 : this.confidence.hashCode());
        result = result * 59 + (this.freq == null ? 43 : this.freq.hashCode());
        result = result * 59 + (this.freqPercentage == null ? 43 : this.freqPercentage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="confidence")
        private Integer confidence;
        @JsonProperty(value="freq")
        private Long freq;
        @JsonProperty(value="freqPercentage")
        private Double freqPercentage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.__explicitlySet__.add("confidence");
            return this;
        }

        public Builder freq(Long freq) {
            this.freq = freq;
            this.__explicitlySet__.add("freq");
            return this;
        }

        public Builder freqPercentage(Double freqPercentage) {
            this.freqPercentage = freqPercentage;
            this.__explicitlySet__.add("freqPercentage");
            return this;
        }

        public DataTypeStat build() {
            DataTypeStat model = new DataTypeStat(this.value, this.confidence, this.freq, this.freqPercentage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataTypeStat model) {
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("confidence")) {
                this.confidence(model.getConfidence());
            }
            if (model.wasPropertyExplicitlySet("freq")) {
                this.freq(model.getFreq());
            }
            if (model.wasPropertyExplicitlySet("freqPercentage")) {
                this.freqPercentage(model.getFreqPercentage());
            }
            return this;
        }
    }
}

