/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.Column;
import com.oracle.bmc.dataconnectivity.model.Row;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataPreview
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityName")
    private final String entityName;
    @JsonProperty(value="sampleRowsCount")
    private final Integer sampleRowsCount;
    @JsonProperty(value="columns")
    private final List<Column> columns;
    @JsonProperty(value="rows")
    private final List<Row> rows;

    @Deprecated
    @ConstructorProperties(value={"entityName", "sampleRowsCount", "columns", "rows"})
    public DataPreview(String entityName, Integer sampleRowsCount, List<Column> columns, List<Row> rows) {
        this.entityName = entityName;
        this.sampleRowsCount = sampleRowsCount;
        this.columns = columns;
        this.rows = rows;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Integer getSampleRowsCount() {
        return this.sampleRowsCount;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataPreview(");
        sb.append("super=").append(super.toString());
        sb.append("entityName=").append(String.valueOf(this.entityName));
        sb.append(", sampleRowsCount=").append(String.valueOf(this.sampleRowsCount));
        sb.append(", columns=").append(String.valueOf(this.columns));
        sb.append(", rows=").append(String.valueOf(this.rows));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataPreview)) {
            return false;
        }
        DataPreview other = (DataPreview)((Object)o);
        return Objects.equals(this.entityName, other.entityName) && Objects.equals(this.sampleRowsCount, other.sampleRowsCount) && Objects.equals(this.columns, other.columns) && Objects.equals(this.rows, other.rows) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.sampleRowsCount == null ? 43 : this.sampleRowsCount.hashCode());
        result = result * 59 + (this.columns == null ? 43 : this.columns.hashCode());
        result = result * 59 + (this.rows == null ? 43 : this.rows.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonProperty(value="sampleRowsCount")
        private Integer sampleRowsCount;
        @JsonProperty(value="columns")
        private List<Column> columns;
        @JsonProperty(value="rows")
        private List<Row> rows;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public Builder sampleRowsCount(Integer sampleRowsCount) {
            this.sampleRowsCount = sampleRowsCount;
            this.__explicitlySet__.add("sampleRowsCount");
            return this;
        }

        public Builder columns(List<Column> columns) {
            this.columns = columns;
            this.__explicitlySet__.add("columns");
            return this;
        }

        public Builder rows(List<Row> rows) {
            this.rows = rows;
            this.__explicitlySet__.add("rows");
            return this;
        }

        public DataPreview build() {
            DataPreview model = new DataPreview(this.entityName, this.sampleRowsCount, this.columns, this.rows);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataPreview model) {
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            if (model.wasPropertyExplicitlySet("sampleRowsCount")) {
                this.sampleRowsCount(model.getSampleRowsCount());
            }
            if (model.wasPropertyExplicitlySet("columns")) {
                this.columns(model.getColumns());
            }
            if (model.wasPropertyExplicitlySet("rows")) {
                this.rows(model.getRows());
            }
            return this;
        }
    }
}

